/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.AddCacheRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class AddCacheRequestMarshaller
implements Marshaller<Request<AddCacheRequest>, AddCacheRequest> {
    @Override
    public Request<AddCacheRequest> marshall(AddCacheRequest addCacheRequest) {
        if (addCacheRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddCacheRequest> request = new DefaultRequest<AddCacheRequest>(addCacheRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.AddCache";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag diskIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addCacheRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(addCacheRequest.getGatewayARN());
            }
            if (!((diskIdsList = (ListWithAutoConstructFlag)addCacheRequest.getDiskIds()) == null || diskIdsList.isAutoConstruct() && diskIdsList.isEmpty())) {
                jsonWriter.key("DiskIds");
                jsonWriter.array();
                for (String diskIdsListValue : diskIdsList) {
                    if (diskIdsListValue == null) continue;
                    jsonWriter.value(diskIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

