/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest;
import com.amazonaws.services.simpleemail.model.ReceiptFilter;
import com.amazonaws.services.simpleemail.model.ReceiptIpFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReceiptFilterRequestMarshaller
implements Marshaller<Request<CreateReceiptFilterRequest>, CreateReceiptFilterRequest> {
    @Override
    public Request<CreateReceiptFilterRequest> marshall(CreateReceiptFilterRequest createReceiptFilterRequest) {
        if (createReceiptFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateReceiptFilterRequest> request = new DefaultRequest<CreateReceiptFilterRequest>(createReceiptFilterRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptFilter");
        request.addParameter("Version", "2010-12-01");
        ReceiptFilter receiptFilterFilter = createReceiptFilterRequest.getFilter();
        if (receiptFilterFilter != null) {
            ReceiptIpFilter receiptIpFilterIpFilter;
            if (receiptFilterFilter.getName() != null) {
                request.addParameter("Filter.Name", StringUtils.fromString(receiptFilterFilter.getName()));
            }
            if ((receiptIpFilterIpFilter = receiptFilterFilter.getIpFilter()) != null) {
                if (receiptIpFilterIpFilter.getPolicy() != null) {
                    request.addParameter("Filter.IpFilter.Policy", StringUtils.fromString(receiptIpFilterIpFilter.getPolicy()));
                }
                if (receiptIpFilterIpFilter.getCidr() != null) {
                    request.addParameter("Filter.IpFilter.Cidr", StringUtils.fromString(receiptIpFilterIpFilter.getCidr()));
                }
            }
        }
        return request;
    }
}

