/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DescribeAppsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeAppsRequestMarshaller
implements Marshaller<Request<DescribeAppsRequest>, DescribeAppsRequest> {
    @Override
    public Request<DescribeAppsRequest> marshall(DescribeAppsRequest describeAppsRequest) {
        if (describeAppsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAppsRequest> request = new DefaultRequest<DescribeAppsRequest>(describeAppsRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeApps";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag appIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeAppsRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeAppsRequest.getStackId());
            }
            if (!((appIdsList = (ListWithAutoConstructFlag)describeAppsRequest.getAppIds()) == null || appIdsList.isAutoConstruct() && appIdsList.isEmpty())) {
                jsonWriter.key("AppIds");
                jsonWriter.array();
                for (String appIdsListValue : appIdsList) {
                    if (appIdsListValue == null) continue;
                    jsonWriter.value(appIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

