/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.AddAttributesToFindingsRequest;
import com.amazonaws.services.inspector.model.Attribute;
import com.amazonaws.services.inspector.model.transform.AttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class AddAttributesToFindingsRequestMarshaller
implements Marshaller<Request<AddAttributesToFindingsRequest>, AddAttributesToFindingsRequest> {
    @Override
    public Request<AddAttributesToFindingsRequest> marshall(AddAttributesToFindingsRequest addAttributesToFindingsRequest) {
        if (addAttributesToFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddAttributesToFindingsRequest> request = new DefaultRequest<AddAttributesToFindingsRequest>(addAttributesToFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.AddAttributesToFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<Attribute> attributesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> findingArnsList = addAttributesToFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonWriter.key("findingArns");
                jsonWriter.array();
                for (String findingArnsListValue : findingArnsList) {
                    if (findingArnsListValue == null) continue;
                    jsonWriter.value(findingArnsListValue);
                }
                jsonWriter.endArray();
            }
            if ((attributesList = addAttributesToFindingsRequest.getAttributes()) != null) {
                jsonWriter.key("attributes");
                jsonWriter.array();
                for (Attribute attributesListValue : attributesList) {
                    if (attributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(attributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

