/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.TaskDefinitionStatus;
import com.amazonaws.services.ecs.model.Volume;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaskDefinition
implements Serializable,
Cloneable {
    private String taskDefinitionArn;
    private ListWithAutoConstructFlag<ContainerDefinition> containerDefinitions;
    private String family;
    private Integer revision;
    private ListWithAutoConstructFlag<Volume> volumes;
    private String status;
    private ListWithAutoConstructFlag<Attribute> requiresAttributes;

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public TaskDefinition withTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new ListWithAutoConstructFlag();
            this.containerDefinitions.setAutoConstruct(true);
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
        containerDefinitionsCopy.addAll(containerDefinitions);
        this.containerDefinitions = containerDefinitionsCopy;
    }

    public TaskDefinition withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.getContainerDefinitions() == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition value : containerDefinitions) {
            this.getContainerDefinitions().add(value);
        }
        return this;
    }

    public TaskDefinition withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
        } else {
            ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
            containerDefinitionsCopy.addAll(containerDefinitions);
            this.containerDefinitions = containerDefinitionsCopy;
        }
        return this;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public TaskDefinition withFamily(String family) {
        this.family = family;
        return this;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public TaskDefinition withRevision(Integer revision) {
        this.revision = revision;
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new ListWithAutoConstructFlag();
            this.volumes.setAutoConstruct(true);
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
        volumesCopy.addAll(volumes);
        this.volumes = volumesCopy;
    }

    public TaskDefinition withVolumes(Volume ... volumes) {
        if (this.getVolumes() == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume value : volumes) {
            this.getVolumes().add(value);
        }
        return this;
    }

    public TaskDefinition withVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
        } else {
            ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
            volumesCopy.addAll(volumes);
            this.volumes = volumesCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TaskDefinition withStatus(String status) {
        this.status = status;
        return this;
    }

    public void setStatus(TaskDefinitionStatus status) {
        this.status = status.toString();
    }

    public TaskDefinition withStatus(TaskDefinitionStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Attribute> getRequiresAttributes() {
        if (this.requiresAttributes == null) {
            this.requiresAttributes = new ListWithAutoConstructFlag();
            this.requiresAttributes.setAutoConstruct(true);
        }
        return this.requiresAttributes;
    }

    public void setRequiresAttributes(Collection<Attribute> requiresAttributes) {
        if (requiresAttributes == null) {
            this.requiresAttributes = null;
            return;
        }
        ListWithAutoConstructFlag requiresAttributesCopy = new ListWithAutoConstructFlag(requiresAttributes.size());
        requiresAttributesCopy.addAll(requiresAttributes);
        this.requiresAttributes = requiresAttributesCopy;
    }

    public TaskDefinition withRequiresAttributes(Attribute ... requiresAttributes) {
        if (this.getRequiresAttributes() == null) {
            this.setRequiresAttributes(new ArrayList<Attribute>(requiresAttributes.length));
        }
        for (Attribute value : requiresAttributes) {
            this.getRequiresAttributes().add(value);
        }
        return this;
    }

    public TaskDefinition withRequiresAttributes(Collection<Attribute> requiresAttributes) {
        if (requiresAttributes == null) {
            this.requiresAttributes = null;
        } else {
            ListWithAutoConstructFlag requiresAttributesCopy = new ListWithAutoConstructFlag(requiresAttributes.size());
            requiresAttributesCopy.addAll(requiresAttributes);
            this.requiresAttributes = requiresAttributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: " + this.getTaskDefinitionArn() + ",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: " + this.getContainerDefinitions() + ",");
        }
        if (this.getFamily() != null) {
            sb.append("Family: " + this.getFamily() + ",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: " + this.getRevision() + ",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: " + this.getVolumes() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getRequiresAttributes() != null) {
            sb.append("RequiresAttributes: " + this.getRequiresAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRequiresAttributes() == null ? 0 : this.getRequiresAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskDefinition)) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)obj;
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        if (other.getRevision() != null && !other.getRevision().equals(this.getRevision())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRequiresAttributes() == null ^ this.getRequiresAttributes() == null) {
            return false;
        }
        return other.getRequiresAttributes() == null || other.getRequiresAttributes().equals(this.getRequiresAttributes());
    }

    public TaskDefinition clone() {
        try {
            return (TaskDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

