/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeComplianceByResourceRequestMarshaller
implements Marshaller<Request<DescribeComplianceByResourceRequest>, DescribeComplianceByResourceRequest> {
    @Override
    public Request<DescribeComplianceByResourceRequest> marshall(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        if (describeComplianceByResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeComplianceByResourceRequest> request = new DefaultRequest<DescribeComplianceByResourceRequest>(describeComplianceByResourceRequest, "AmazonConfig");
        String target = "StarlingDoveService.DescribeComplianceByResource";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag complianceTypesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeComplianceByResourceRequest.getResourceType() != null) {
                jsonWriter.key("ResourceType").value(describeComplianceByResourceRequest.getResourceType());
            }
            if (describeComplianceByResourceRequest.getResourceId() != null) {
                jsonWriter.key("ResourceId").value(describeComplianceByResourceRequest.getResourceId());
            }
            if (!((complianceTypesList = (ListWithAutoConstructFlag)describeComplianceByResourceRequest.getComplianceTypes()) == null || complianceTypesList.isAutoConstruct() && complianceTypesList.isEmpty())) {
                jsonWriter.key("ComplianceTypes");
                jsonWriter.array();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonWriter.value(complianceTypesListValue);
                }
                jsonWriter.endArray();
            }
            if (describeComplianceByResourceRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeComplianceByResourceRequest.getLimit());
            }
            if (describeComplianceByResourceRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeComplianceByResourceRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

