/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.Evaluation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutEvaluationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Evaluation> evaluations;
    private String resultToken;

    public List<Evaluation> getEvaluations() {
        if (this.evaluations == null) {
            this.evaluations = new ListWithAutoConstructFlag();
            this.evaluations.setAutoConstruct(true);
        }
        return this.evaluations;
    }

    public void setEvaluations(Collection<Evaluation> evaluations) {
        if (evaluations == null) {
            this.evaluations = null;
            return;
        }
        ListWithAutoConstructFlag evaluationsCopy = new ListWithAutoConstructFlag(evaluations.size());
        evaluationsCopy.addAll(evaluations);
        this.evaluations = evaluationsCopy;
    }

    public PutEvaluationsRequest withEvaluations(Evaluation ... evaluations) {
        if (this.getEvaluations() == null) {
            this.setEvaluations(new ArrayList<Evaluation>(evaluations.length));
        }
        for (Evaluation value : evaluations) {
            this.getEvaluations().add(value);
        }
        return this;
    }

    public PutEvaluationsRequest withEvaluations(Collection<Evaluation> evaluations) {
        if (evaluations == null) {
            this.evaluations = null;
        } else {
            ListWithAutoConstructFlag evaluationsCopy = new ListWithAutoConstructFlag(evaluations.size());
            evaluationsCopy.addAll(evaluations);
            this.evaluations = evaluationsCopy;
        }
        return this;
    }

    public String getResultToken() {
        return this.resultToken;
    }

    public void setResultToken(String resultToken) {
        this.resultToken = resultToken;
    }

    public PutEvaluationsRequest withResultToken(String resultToken) {
        this.resultToken = resultToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluations() != null) {
            sb.append("Evaluations: " + this.getEvaluations() + ",");
        }
        if (this.getResultToken() != null) {
            sb.append("ResultToken: " + this.getResultToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluations() == null ? 0 : this.getEvaluations().hashCode());
        hashCode = 31 * hashCode + (this.getResultToken() == null ? 0 : this.getResultToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsRequest)) {
            return false;
        }
        PutEvaluationsRequest other = (PutEvaluationsRequest)obj;
        if (other.getEvaluations() == null ^ this.getEvaluations() == null) {
            return false;
        }
        if (other.getEvaluations() != null && !other.getEvaluations().equals(this.getEvaluations())) {
            return false;
        }
        if (other.getResultToken() == null ^ this.getResultToken() == null) {
            return false;
        }
        return other.getResultToken() == null || other.getResultToken().equals(this.getResultToken());
    }

    @Override
    public PutEvaluationsRequest clone() {
        return (PutEvaluationsRequest)super.clone();
    }
}

