/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.TagFilter;
import com.amazonaws.services.codedeploy.model.UpdateDeploymentGroupRequest;
import com.amazonaws.services.codedeploy.model.transform.EC2TagFilterJsonMarshaller;
import com.amazonaws.services.codedeploy.model.transform.TagFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateDeploymentGroupRequestMarshaller
implements Marshaller<Request<UpdateDeploymentGroupRequest>, UpdateDeploymentGroupRequest> {
    @Override
    public Request<UpdateDeploymentGroupRequest> marshall(UpdateDeploymentGroupRequest updateDeploymentGroupRequest) {
        if (updateDeploymentGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDeploymentGroupRequest> request = new DefaultRequest<UpdateDeploymentGroupRequest>(updateDeploymentGroupRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.UpdateDeploymentGroup");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList autoScalingGroupsList;
            SdkInternalList onPremisesInstanceTagFiltersList;
            SdkInternalList ec2TagFiltersList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateDeploymentGroupRequest.getApplicationName() != null) {
                jsonWriter.key("applicationName").value(updateDeploymentGroupRequest.getApplicationName());
            }
            if (updateDeploymentGroupRequest.getCurrentDeploymentGroupName() != null) {
                jsonWriter.key("currentDeploymentGroupName").value(updateDeploymentGroupRequest.getCurrentDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getNewDeploymentGroupName() != null) {
                jsonWriter.key("newDeploymentGroupName").value(updateDeploymentGroupRequest.getNewDeploymentGroupName());
            }
            if (updateDeploymentGroupRequest.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(updateDeploymentGroupRequest.getDeploymentConfigName());
            }
            if (!(ec2TagFiltersList = (SdkInternalList)updateDeploymentGroupRequest.getEc2TagFilters()).isEmpty() || !ec2TagFiltersList.isAutoConstruct()) {
                jsonWriter.key("ec2TagFilters");
                jsonWriter.array();
                for (EC2TagFilter ec2TagFiltersListValue : ec2TagFiltersList) {
                    if (ec2TagFiltersListValue == null) continue;
                    EC2TagFilterJsonMarshaller.getInstance().marshall(ec2TagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(onPremisesInstanceTagFiltersList = (SdkInternalList)updateDeploymentGroupRequest.getOnPremisesInstanceTagFilters()).isEmpty() || !onPremisesInstanceTagFiltersList.isAutoConstruct()) {
                jsonWriter.key("onPremisesInstanceTagFilters");
                jsonWriter.array();
                for (TagFilter onPremisesInstanceTagFiltersListValue : onPremisesInstanceTagFiltersList) {
                    if (onPremisesInstanceTagFiltersListValue == null) continue;
                    TagFilterJsonMarshaller.getInstance().marshall(onPremisesInstanceTagFiltersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(autoScalingGroupsList = (SdkInternalList)updateDeploymentGroupRequest.getAutoScalingGroups()).isEmpty() || !autoScalingGroupsList.isAutoConstruct()) {
                jsonWriter.key("autoScalingGroups");
                jsonWriter.array();
                for (String autoScalingGroupsListValue : autoScalingGroupsList) {
                    if (autoScalingGroupsListValue == null) continue;
                    jsonWriter.value(autoScalingGroupsListValue);
                }
                jsonWriter.endArray();
            }
            if (updateDeploymentGroupRequest.getServiceRoleArn() != null) {
                jsonWriter.key("serviceRoleArn").value(updateDeploymentGroupRequest.getServiceRoleArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

