/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> resourceIdList;
    private String nextToken;

    public List<String> getResourceIdList() {
        if (this.resourceIdList == null) {
            this.resourceIdList = new ListWithAutoConstructFlag();
            this.resourceIdList.setAutoConstruct(true);
        }
        return this.resourceIdList;
    }

    public void setResourceIdList(Collection<String> resourceIdList) {
        if (resourceIdList == null) {
            this.resourceIdList = null;
            return;
        }
        ListWithAutoConstructFlag resourceIdListCopy = new ListWithAutoConstructFlag(resourceIdList.size());
        resourceIdListCopy.addAll(resourceIdList);
        this.resourceIdList = resourceIdListCopy;
    }

    public ListTagsRequest withResourceIdList(String ... resourceIdList) {
        if (this.getResourceIdList() == null) {
            this.setResourceIdList(new ArrayList<String>(resourceIdList.length));
        }
        for (String value : resourceIdList) {
            this.getResourceIdList().add(value);
        }
        return this;
    }

    public ListTagsRequest withResourceIdList(Collection<String> resourceIdList) {
        if (resourceIdList == null) {
            this.resourceIdList = null;
        } else {
            ListWithAutoConstructFlag resourceIdListCopy = new ListWithAutoConstructFlag(resourceIdList.size());
            resourceIdListCopy.addAll(resourceIdList);
            this.resourceIdList = resourceIdListCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListTagsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdList() != null) {
            sb.append("ResourceIdList: " + this.getResourceIdList() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdList() == null ? 0 : this.getResourceIdList().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest)obj;
        if (other.getResourceIdList() == null ^ this.getResourceIdList() == null) {
            return false;
        }
        if (other.getResourceIdList() != null && !other.getResourceIdList().equals(this.getResourceIdList())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    @Override
    public ListTagsRequest clone() {
        return (ListTagsRequest)super.clone();
    }
}

