/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceId;
    private ListWithAutoConstructFlag<Tag> tagsList;

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public AddTagsRequest withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public List<Tag> getTagsList() {
        if (this.tagsList == null) {
            this.tagsList = new ListWithAutoConstructFlag();
            this.tagsList.setAutoConstruct(true);
        }
        return this.tagsList;
    }

    public void setTagsList(Collection<Tag> tagsList) {
        if (tagsList == null) {
            this.tagsList = null;
            return;
        }
        ListWithAutoConstructFlag tagsListCopy = new ListWithAutoConstructFlag(tagsList.size());
        tagsListCopy.addAll(tagsList);
        this.tagsList = tagsListCopy;
    }

    public AddTagsRequest withTagsList(Tag ... tagsList) {
        if (this.getTagsList() == null) {
            this.setTagsList(new ArrayList<Tag>(tagsList.length));
        }
        for (Tag value : tagsList) {
            this.getTagsList().add(value);
        }
        return this;
    }

    public AddTagsRequest withTagsList(Collection<Tag> tagsList) {
        if (tagsList == null) {
            this.tagsList = null;
        } else {
            ListWithAutoConstructFlag tagsListCopy = new ListWithAutoConstructFlag(tagsList.size());
            tagsListCopy.addAll(tagsList);
            this.tagsList = tagsListCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceId() != null) {
            sb.append("ResourceId: " + this.getResourceId() + ",");
        }
        if (this.getTagsList() != null) {
            sb.append("TagsList: " + this.getTagsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getTagsList() == null ? 0 : this.getTagsList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsRequest)) {
            return false;
        }
        AddTagsRequest other = (AddTagsRequest)obj;
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getTagsList() == null ^ this.getTagsList() == null) {
            return false;
        }
        return other.getTagsList() == null || other.getTagsList().equals(this.getTagsList());
    }

    @Override
    public AddTagsRequest clone() {
        return (AddTagsRequest)super.clone();
    }
}

