/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.kinesisfirehose.model;

import java.io.Serializable;

/**
 * <p>
 * Contains the output of <a>DescribeDeliveryStream</a>.
 * </p>
 */
public class DescribeDeliveryStreamResult implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the delivery stream.
     * </p>
     */
    private DeliveryStreamDescription deliveryStreamDescription;

    /**
     * <p>
     * Information about the delivery stream.
     * </p>
     * 
     * @param deliveryStreamDescription
     *        Information about the delivery stream.
     */
    public void setDeliveryStreamDescription(
            DeliveryStreamDescription deliveryStreamDescription) {
        this.deliveryStreamDescription = deliveryStreamDescription;
    }

    /**
     * <p>
     * Information about the delivery stream.
     * </p>
     * 
     * @return Information about the delivery stream.
     */
    public DeliveryStreamDescription getDeliveryStreamDescription() {
        return this.deliveryStreamDescription;
    }

    /**
     * <p>
     * Information about the delivery stream.
     * </p>
     * 
     * @param deliveryStreamDescription
     *        Information about the delivery stream.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public DescribeDeliveryStreamResult withDeliveryStreamDescription(
            DeliveryStreamDescription deliveryStreamDescription) {
        setDeliveryStreamDescription(deliveryStreamDescription);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDeliveryStreamDescription() != null)
            sb.append("DeliveryStreamDescription: "
                    + getDeliveryStreamDescription());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeDeliveryStreamResult == false)
            return false;
        DescribeDeliveryStreamResult other = (DescribeDeliveryStreamResult) obj;
        if (other.getDeliveryStreamDescription() == null
                ^ this.getDeliveryStreamDescription() == null)
            return false;
        if (other.getDeliveryStreamDescription() != null
                && other.getDeliveryStreamDescription().equals(
                        this.getDeliveryStreamDescription()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime
                * hashCode
                + ((getDeliveryStreamDescription() == null) ? 0
                        : getDeliveryStreamDescription().hashCode());
        return hashCode;
    }

    @Override
    public DescribeDeliveryStreamResult clone() {
        try {
            return (DescribeDeliveryStreamResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}