/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.workspaces.model.RebootRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RebootWorkspacesRequestMarshaller
implements Marshaller<Request<RebootWorkspacesRequest>, RebootWorkspacesRequest> {
    @Override
    public Request<RebootWorkspacesRequest> marshall(RebootWorkspacesRequest rebootWorkspacesRequest) {
        if (rebootWorkspacesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RebootWorkspacesRequest> request = new DefaultRequest<RebootWorkspacesRequest>(rebootWorkspacesRequest, "AmazonWorkspaces");
        String target = "WorkspacesService.RebootWorkspaces";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag rebootWorkspaceRequestsList = (ListWithAutoConstructFlag)rebootWorkspacesRequest.getRebootWorkspaceRequests();
            if (!(rebootWorkspaceRequestsList == null || rebootWorkspaceRequestsList.isAutoConstruct() && rebootWorkspaceRequestsList.isEmpty())) {
                jsonWriter.key("RebootWorkspaceRequests");
                jsonWriter.array();
                for (RebootRequest rebootWorkspaceRequestsListValue : rebootWorkspaceRequestsList) {
                    if (rebootWorkspaceRequestsListValue == null) continue;
                    jsonWriter.object();
                    if (rebootWorkspaceRequestsListValue.getWorkspaceId() != null) {
                        jsonWriter.key("WorkspaceId").value(rebootWorkspaceRequestsListValue.getWorkspaceId());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

