/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ConfirmSubscriptionRequestMarshaller
implements Marshaller<Request<ConfirmSubscriptionRequest>, ConfirmSubscriptionRequest> {
    @Override
    public Request<ConfirmSubscriptionRequest> marshall(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        if (confirmSubscriptionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConfirmSubscriptionRequest> request = new DefaultRequest<ConfirmSubscriptionRequest>(confirmSubscriptionRequest, "AmazonSNS");
        request.addParameter("Action", "ConfirmSubscription");
        request.addParameter("Version", "2010-03-31");
        if (confirmSubscriptionRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(confirmSubscriptionRequest.getTopicArn()));
        }
        if (confirmSubscriptionRequest.getToken() != null) {
            request.addParameter("Token", StringUtils.fromString(confirmSubscriptionRequest.getToken()));
        }
        if (confirmSubscriptionRequest.getAuthenticateOnUnsubscribe() != null) {
            request.addParameter("AuthenticateOnUnsubscribe", StringUtils.fromString(confirmSubscriptionRequest.getAuthenticateOnUnsubscribe()));
        }
        return request;
    }
}

