/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementAsync;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClient;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationBatchResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.CreateDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DeleteDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeAssociationResult;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.DescribeDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentRequest;
import com.amazonaws.services.simplesystemsmanagement.model.GetDocumentResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListAssociationsResult;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsResult;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusRequest;
import com.amazonaws.services.simplesystemsmanagement.model.UpdateAssociationStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AWSSimpleSystemsManagementAsyncClient
extends AWSSimpleSystemsManagementClient
implements AWSSimpleSystemsManagementAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AWSSimpleSystemsManagementAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSSimpleSystemsManagementAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSimpleSystemsManagementAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(final DeleteDocumentRequest deleteDocumentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDocumentResult>(){

            @Override
            public DeleteDocumentResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.deleteDocument(deleteDocumentRequest);
            }
        });
    }

    @Override
    public Future<DeleteDocumentResult> deleteDocumentAsync(final DeleteDocumentRequest deleteDocumentRequest, final AsyncHandler<DeleteDocumentRequest, DeleteDocumentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteDocumentResult>(){

            @Override
            public DeleteDocumentResult call() throws Exception {
                DeleteDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deleteDocument(deleteDocumentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDocumentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAssociationResult> describeAssociationAsync(final DescribeAssociationRequest describeAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAssociationResult>(){

            @Override
            public DescribeAssociationResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.describeAssociation(describeAssociationRequest);
            }
        });
    }

    @Override
    public Future<DescribeAssociationResult> describeAssociationAsync(final DescribeAssociationRequest describeAssociationRequest, final AsyncHandler<DescribeAssociationRequest, DescribeAssociationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeAssociationResult>(){

            @Override
            public DescribeAssociationResult call() throws Exception {
                DescribeAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeAssociation(describeAssociationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeAssociationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssociationResult> createAssociationAsync(final CreateAssociationRequest createAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAssociationResult>(){

            @Override
            public CreateAssociationResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.createAssociation(createAssociationRequest);
            }
        });
    }

    @Override
    public Future<CreateAssociationResult> createAssociationAsync(final CreateAssociationRequest createAssociationRequest, final AsyncHandler<CreateAssociationRequest, CreateAssociationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAssociationResult>(){

            @Override
            public CreateAssociationResult call() throws Exception {
                CreateAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createAssociation(createAssociationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createAssociationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateAssociationBatchResult> createAssociationBatchAsync(final CreateAssociationBatchRequest createAssociationBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAssociationBatchResult>(){

            @Override
            public CreateAssociationBatchResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.createAssociationBatch(createAssociationBatchRequest);
            }
        });
    }

    @Override
    public Future<CreateAssociationBatchResult> createAssociationBatchAsync(final CreateAssociationBatchRequest createAssociationBatchRequest, final AsyncHandler<CreateAssociationBatchRequest, CreateAssociationBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateAssociationBatchResult>(){

            @Override
            public CreateAssociationBatchResult call() throws Exception {
                CreateAssociationBatchResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createAssociationBatch(createAssociationBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createAssociationBatchRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDocumentResult> describeDocumentAsync(final DescribeDocumentRequest describeDocumentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDocumentResult>(){

            @Override
            public DescribeDocumentResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.describeDocument(describeDocumentRequest);
            }
        });
    }

    @Override
    public Future<DescribeDocumentResult> describeDocumentAsync(final DescribeDocumentRequest describeDocumentRequest, final AsyncHandler<DescribeDocumentRequest, DescribeDocumentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDocumentResult>(){

            @Override
            public DescribeDocumentResult call() throws Exception {
                DescribeDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.describeDocument(describeDocumentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDocumentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAssociationStatusResult> updateAssociationStatusAsync(final UpdateAssociationStatusRequest updateAssociationStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateAssociationStatusResult>(){

            @Override
            public UpdateAssociationStatusResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.updateAssociationStatus(updateAssociationStatusRequest);
            }
        });
    }

    @Override
    public Future<UpdateAssociationStatusResult> updateAssociationStatusAsync(final UpdateAssociationStatusRequest updateAssociationStatusRequest, final AsyncHandler<UpdateAssociationStatusRequest, UpdateAssociationStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateAssociationStatusResult>(){

            @Override
            public UpdateAssociationStatusResult call() throws Exception {
                UpdateAssociationStatusResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.updateAssociationStatus(updateAssociationStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateAssociationStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociationsResult> listAssociationsAsync(final ListAssociationsRequest listAssociationsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAssociationsResult>(){

            @Override
            public ListAssociationsResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.listAssociations(listAssociationsRequest);
            }
        });
    }

    @Override
    public Future<ListAssociationsResult> listAssociationsAsync(final ListAssociationsRequest listAssociationsRequest, final AsyncHandler<ListAssociationsRequest, ListAssociationsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListAssociationsResult>(){

            @Override
            public ListAssociationsResult call() throws Exception {
                ListAssociationsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listAssociations(listAssociationsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listAssociationsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync(final ListDocumentsRequest listDocumentsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDocumentsResult>(){

            @Override
            public ListDocumentsResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.listDocuments(listDocumentsRequest);
            }
        });
    }

    @Override
    public Future<ListDocumentsResult> listDocumentsAsync(final ListDocumentsRequest listDocumentsRequest, final AsyncHandler<ListDocumentsRequest, ListDocumentsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDocumentsResult>(){

            @Override
            public ListDocumentsResult call() throws Exception {
                ListDocumentsResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.listDocuments(listDocumentsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(listDocumentsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAssociationResult> deleteAssociationAsync(final DeleteAssociationRequest deleteAssociationRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteAssociationResult>(){

            @Override
            public DeleteAssociationResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.deleteAssociation(deleteAssociationRequest);
            }
        });
    }

    @Override
    public Future<DeleteAssociationResult> deleteAssociationAsync(final DeleteAssociationRequest deleteAssociationRequest, final AsyncHandler<DeleteAssociationRequest, DeleteAssociationResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteAssociationResult>(){

            @Override
            public DeleteAssociationResult call() throws Exception {
                DeleteAssociationResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.deleteAssociation(deleteAssociationRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteAssociationRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateDocumentResult> createDocumentAsync(final CreateDocumentRequest createDocumentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDocumentResult>(){

            @Override
            public CreateDocumentResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.createDocument(createDocumentRequest);
            }
        });
    }

    @Override
    public Future<CreateDocumentResult> createDocumentAsync(final CreateDocumentRequest createDocumentRequest, final AsyncHandler<CreateDocumentRequest, CreateDocumentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateDocumentResult>(){

            @Override
            public CreateDocumentResult call() throws Exception {
                CreateDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.createDocument(createDocumentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createDocumentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(final GetDocumentRequest getDocumentRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDocumentResult>(){

            @Override
            public GetDocumentResult call() throws Exception {
                return AWSSimpleSystemsManagementAsyncClient.this.getDocument(getDocumentRequest);
            }
        });
    }

    @Override
    public Future<GetDocumentResult> getDocumentAsync(final GetDocumentRequest getDocumentRequest, final AsyncHandler<GetDocumentRequest, GetDocumentResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetDocumentResult>(){

            @Override
            public GetDocumentResult call() throws Exception {
                GetDocumentResult result;
                try {
                    result = AWSSimpleSystemsManagementAsyncClient.this.getDocument(getDocumentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getDocumentRequest, result);
                return result;
            }
        });
    }
}

