/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.CreateLayerRequest;
import com.amazonaws.services.opsworks.model.LifecycleEventConfiguration;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.ShutdownEventConfiguration;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class CreateLayerRequestMarshaller
implements Marshaller<Request<CreateLayerRequest>, CreateLayerRequest> {
    @Override
    public Request<CreateLayerRequest> marshall(CreateLayerRequest createLayerRequest) {
        if (createLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLayerRequest> request = new DefaultRequest<CreateLayerRequest>(createLayerRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateLayer";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            LifecycleEventConfiguration lifecycleEventConfiguration;
            Recipes customRecipes;
            ListWithAutoConstructFlag volumeConfigurationsList;
            ListWithAutoConstructFlag packagesList;
            ListWithAutoConstructFlag customSecurityGroupIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createLayerRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createLayerRequest.getStackId());
            }
            if (createLayerRequest.getType() != null) {
                jsonWriter.key("Type").value(createLayerRequest.getType());
            }
            if (createLayerRequest.getName() != null) {
                jsonWriter.key("Name").value(createLayerRequest.getName());
            }
            if (createLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value(createLayerRequest.getShortname());
            }
            if (createLayerRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : createLayerRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value(createLayerRequest.getCustomInstanceProfileArn());
            }
            if (!((customSecurityGroupIdsList = (ListWithAutoConstructFlag)createLayerRequest.getCustomSecurityGroupIds()) == null || customSecurityGroupIdsList.isAutoConstruct() && customSecurityGroupIdsList.isEmpty())) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value(customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!((packagesList = (ListWithAutoConstructFlag)createLayerRequest.getPackages()) == null || packagesList.isAutoConstruct() && packagesList.isEmpty())) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value(packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!((volumeConfigurationsList = (ListWithAutoConstructFlag)createLayerRequest.getVolumeConfigurations()) == null || volumeConfigurationsList.isAutoConstruct() && volumeConfigurationsList.isEmpty())) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    jsonWriter.object();
                    if (volumeConfigurationsListValue.getMountPoint() != null) {
                        jsonWriter.key("MountPoint").value(volumeConfigurationsListValue.getMountPoint());
                    }
                    if (volumeConfigurationsListValue.getRaidLevel() != null) {
                        jsonWriter.key("RaidLevel").value(volumeConfigurationsListValue.getRaidLevel());
                    }
                    if (volumeConfigurationsListValue.getNumberOfDisks() != null) {
                        jsonWriter.key("NumberOfDisks").value(volumeConfigurationsListValue.getNumberOfDisks());
                    }
                    if (volumeConfigurationsListValue.getSize() != null) {
                        jsonWriter.key("Size").value(volumeConfigurationsListValue.getSize());
                    }
                    if (volumeConfigurationsListValue.getVolumeType() != null) {
                        jsonWriter.key("VolumeType").value(volumeConfigurationsListValue.getVolumeType());
                    }
                    if (volumeConfigurationsListValue.getIops() != null) {
                        jsonWriter.key("Iops").value(volumeConfigurationsListValue.getIops());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createLayerRequest.isEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value(createLayerRequest.isEnableAutoHealing());
            }
            if (createLayerRequest.isAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value(createLayerRequest.isAutoAssignElasticIps());
            }
            if (createLayerRequest.isAutoAssignPublicIps() != null) {
                jsonWriter.key("AutoAssignPublicIps").value(createLayerRequest.isAutoAssignPublicIps());
            }
            if ((customRecipes = createLayerRequest.getCustomRecipes()) != null) {
                ListWithAutoConstructFlag shutdownList;
                ListWithAutoConstructFlag undeployList;
                ListWithAutoConstructFlag deployList;
                ListWithAutoConstructFlag configureList;
                jsonWriter.key("CustomRecipes");
                jsonWriter.object();
                ListWithAutoConstructFlag setupList = (ListWithAutoConstructFlag)customRecipes.getSetup();
                if (!(setupList == null || setupList.isAutoConstruct() && setupList.isEmpty())) {
                    jsonWriter.key("Setup");
                    jsonWriter.array();
                    for (String setupListValue : setupList) {
                        if (setupListValue == null) continue;
                        jsonWriter.value(setupListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((configureList = (ListWithAutoConstructFlag)customRecipes.getConfigure()) == null || configureList.isAutoConstruct() && configureList.isEmpty())) {
                    jsonWriter.key("Configure");
                    jsonWriter.array();
                    for (String configureListValue : configureList) {
                        if (configureListValue == null) continue;
                        jsonWriter.value(configureListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((deployList = (ListWithAutoConstructFlag)customRecipes.getDeploy()) == null || deployList.isAutoConstruct() && deployList.isEmpty())) {
                    jsonWriter.key("Deploy");
                    jsonWriter.array();
                    for (String deployListValue : deployList) {
                        if (deployListValue == null) continue;
                        jsonWriter.value(deployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((undeployList = (ListWithAutoConstructFlag)customRecipes.getUndeploy()) == null || undeployList.isAutoConstruct() && undeployList.isEmpty())) {
                    jsonWriter.key("Undeploy");
                    jsonWriter.array();
                    for (String undeployListValue : undeployList) {
                        if (undeployListValue == null) continue;
                        jsonWriter.value(undeployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((shutdownList = (ListWithAutoConstructFlag)customRecipes.getShutdown()) == null || shutdownList.isAutoConstruct() && shutdownList.isEmpty())) {
                    jsonWriter.key("Shutdown");
                    jsonWriter.array();
                    for (String shutdownListValue : shutdownList) {
                        if (shutdownListValue == null) continue;
                        jsonWriter.value(shutdownListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (createLayerRequest.isInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value(createLayerRequest.isInstallUpdatesOnBoot());
            }
            if (createLayerRequest.isUseEbsOptimizedInstances() != null) {
                jsonWriter.key("UseEbsOptimizedInstances").value(createLayerRequest.isUseEbsOptimizedInstances());
            }
            if ((lifecycleEventConfiguration = createLayerRequest.getLifecycleEventConfiguration()) != null) {
                jsonWriter.key("LifecycleEventConfiguration");
                jsonWriter.object();
                ShutdownEventConfiguration shutdown = lifecycleEventConfiguration.getShutdown();
                if (shutdown != null) {
                    jsonWriter.key("Shutdown");
                    jsonWriter.object();
                    if (shutdown.getExecutionTimeout() != null) {
                        jsonWriter.key("ExecutionTimeout").value(shutdown.getExecutionTimeout());
                    }
                    if (shutdown.isDelayUntilElbConnectionsDrained() != null) {
                        jsonWriter.key("DelayUntilElbConnectionsDrained").value(shutdown.isDelayUntilElbConnectionsDrained());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

