/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.VersionInfo;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RegisterContainerInstanceRequestMarshaller
implements Marshaller<Request<RegisterContainerInstanceRequest>, RegisterContainerInstanceRequest> {
    @Override
    public Request<RegisterContainerInstanceRequest> marshall(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        if (registerContainerInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterContainerInstanceRequest> request = new DefaultRequest<RegisterContainerInstanceRequest>(registerContainerInstanceRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.RegisterContainerInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            VersionInfo versionInfo;
            ListWithAutoConstructFlag totalResourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (registerContainerInstanceRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(registerContainerInstanceRequest.getCluster());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocument() != null) {
                jsonWriter.key("instanceIdentityDocument").value(registerContainerInstanceRequest.getInstanceIdentityDocument());
            }
            if (registerContainerInstanceRequest.getInstanceIdentityDocumentSignature() != null) {
                jsonWriter.key("instanceIdentityDocumentSignature").value(registerContainerInstanceRequest.getInstanceIdentityDocumentSignature());
            }
            if (!((totalResourcesList = (ListWithAutoConstructFlag)registerContainerInstanceRequest.getTotalResources()) == null || totalResourcesList.isAutoConstruct() && totalResourcesList.isEmpty())) {
                jsonWriter.key("totalResources");
                jsonWriter.array();
                for (Resource totalResourcesListValue : totalResourcesList) {
                    ListWithAutoConstructFlag stringSetValueList;
                    if (totalResourcesListValue == null) continue;
                    jsonWriter.object();
                    if (totalResourcesListValue.getName() != null) {
                        jsonWriter.key("name").value(totalResourcesListValue.getName());
                    }
                    if (totalResourcesListValue.getType() != null) {
                        jsonWriter.key("type").value(totalResourcesListValue.getType());
                    }
                    if (totalResourcesListValue.getDoubleValue() != null) {
                        jsonWriter.key("doubleValue").value(totalResourcesListValue.getDoubleValue());
                    }
                    if (totalResourcesListValue.getLongValue() != null) {
                        jsonWriter.key("longValue").value(totalResourcesListValue.getLongValue());
                    }
                    if (totalResourcesListValue.getIntegerValue() != null) {
                        jsonWriter.key("integerValue").value(totalResourcesListValue.getIntegerValue());
                    }
                    if (!((stringSetValueList = (ListWithAutoConstructFlag)totalResourcesListValue.getStringSetValue()) == null || stringSetValueList.isAutoConstruct() && stringSetValueList.isEmpty())) {
                        jsonWriter.key("stringSetValue");
                        jsonWriter.array();
                        for (String stringSetValueListValue : stringSetValueList) {
                            if (stringSetValueListValue == null) continue;
                            jsonWriter.value(stringSetValueListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if ((versionInfo = registerContainerInstanceRequest.getVersionInfo()) != null) {
                jsonWriter.key("versionInfo");
                jsonWriter.object();
                if (versionInfo.getAgentVersion() != null) {
                    jsonWriter.key("agentVersion").value(versionInfo.getAgentVersion());
                }
                if (versionInfo.getAgentHash() != null) {
                    jsonWriter.key("agentHash").value(versionInfo.getAgentHash());
                }
                if (versionInfo.getDockerVersion() != null) {
                    jsonWriter.key("dockerVersion").value(versionInfo.getDockerVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

