/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Projection
implements Serializable,
Cloneable {
    private String projectionType;
    private ListWithAutoConstructFlag<String> nonKeyAttributes;

    public String getProjectionType() {
        return this.projectionType;
    }

    public void setProjectionType(String projectionType) {
        this.projectionType = projectionType;
    }

    public Projection withProjectionType(String projectionType) {
        this.projectionType = projectionType;
        return this;
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType.toString();
    }

    public Projection withProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType.toString();
        return this;
    }

    public List<String> getNonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
        if (nonKeyAttributes == null) {
            this.nonKeyAttributes = null;
            return;
        }
        ListWithAutoConstructFlag nonKeyAttributesCopy = new ListWithAutoConstructFlag(nonKeyAttributes.size());
        nonKeyAttributesCopy.addAll(nonKeyAttributes);
        this.nonKeyAttributes = nonKeyAttributesCopy;
    }

    public Projection withNonKeyAttributes(String ... nonKeyAttributes) {
        if (this.getNonKeyAttributes() == null) {
            this.setNonKeyAttributes(new ArrayList<String>(nonKeyAttributes.length));
        }
        for (String value : nonKeyAttributes) {
            this.getNonKeyAttributes().add(value);
        }
        return this;
    }

    public Projection withNonKeyAttributes(Collection<String> nonKeyAttributes) {
        if (nonKeyAttributes == null) {
            this.nonKeyAttributes = null;
        } else {
            ListWithAutoConstructFlag nonKeyAttributesCopy = new ListWithAutoConstructFlag(nonKeyAttributes.size());
            nonKeyAttributesCopy.addAll(nonKeyAttributes);
            this.nonKeyAttributes = nonKeyAttributesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectionType() != null) {
            sb.append("ProjectionType: " + this.getProjectionType() + ",");
        }
        if (this.getNonKeyAttributes() != null) {
            sb.append("NonKeyAttributes: " + this.getNonKeyAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectionType() == null ? 0 : this.getProjectionType().hashCode());
        hashCode = 31 * hashCode + (this.getNonKeyAttributes() == null ? 0 : this.getNonKeyAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)obj;
        if (other.getProjectionType() == null ^ this.getProjectionType() == null) {
            return false;
        }
        if (other.getProjectionType() != null && !other.getProjectionType().equals(this.getProjectionType())) {
            return false;
        }
        if (other.getNonKeyAttributes() == null ^ this.getNonKeyAttributes() == null) {
            return false;
        }
        return other.getNonKeyAttributes() == null || other.getNonKeyAttributes().equals(this.getNonKeyAttributes());
    }

    public Projection clone() {
        try {
            return (Projection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

