/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocalSecondaryIndexDescription
implements Serializable,
Cloneable {
    private String indexName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private Projection projection;
    private Long indexSizeBytes;
    private Long itemCount;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public LocalSecondaryIndexDescription withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
        keySchemaCopy.addAll(keySchema);
        this.keySchema = keySchemaCopy;
    }

    public LocalSecondaryIndexDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement value : keySchema) {
            this.getKeySchema().add(value);
        }
        return this;
    }

    public LocalSecondaryIndexDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
            keySchemaCopy.addAll(keySchema);
            this.keySchema = keySchemaCopy;
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public LocalSecondaryIndexDescription withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public Long getIndexSizeBytes() {
        return this.indexSizeBytes;
    }

    public void setIndexSizeBytes(Long indexSizeBytes) {
        this.indexSizeBytes = indexSizeBytes;
    }

    public LocalSecondaryIndexDescription withIndexSizeBytes(Long indexSizeBytes) {
        this.indexSizeBytes = indexSizeBytes;
        return this;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public LocalSecondaryIndexDescription withItemCount(Long itemCount) {
        this.itemCount = itemCount;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexName() != null) {
            sb.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            sb.append("Projection: " + this.getProjection() + ",");
        }
        if (this.getIndexSizeBytes() != null) {
            sb.append("IndexSizeBytes: " + this.getIndexSizeBytes() + ",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: " + this.getItemCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        hashCode = 31 * hashCode + (this.getIndexSizeBytes() == null ? 0 : this.getIndexSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalSecondaryIndexDescription)) {
            return false;
        }
        LocalSecondaryIndexDescription other = (LocalSecondaryIndexDescription)obj;
        if (other.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (other.getIndexName() != null && !other.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (other.getProjection() != null && !other.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (other.getIndexSizeBytes() == null ^ this.getIndexSizeBytes() == null) {
            return false;
        }
        if (other.getIndexSizeBytes() != null && !other.getIndexSizeBytes().equals(this.getIndexSizeBytes())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        return other.getItemCount() == null || other.getItemCount().equals(this.getItemCount());
    }

    public LocalSecondaryIndexDescription clone() {
        try {
            return (LocalSecondaryIndexDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

