/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.organizations.model.Parent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListParentsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Parent> parents;
    private String nextToken;

    public List<Parent> getParents() {
        return this.parents;
    }

    public void setParents(Collection<Parent> parents) {
        if (parents == null) {
            this.parents = null;
            return;
        }
        this.parents = new ArrayList<Parent>(parents);
    }

    public ListParentsResult withParents(Parent ... parents) {
        if (this.parents == null) {
            this.setParents(new ArrayList<Parent>(parents.length));
        }
        for (Parent ele : parents) {
            this.parents.add(ele);
        }
        return this;
    }

    public ListParentsResult withParents(Collection<Parent> parents) {
        this.setParents(parents);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListParentsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParents() != null) {
            sb.append("Parents: ").append(this.getParents()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParentsResult)) {
            return false;
        }
        ListParentsResult other = (ListParentsResult)obj;
        if (other.getParents() == null ^ this.getParents() == null) {
            return false;
        }
        if (other.getParents() != null && !other.getParents().equals(this.getParents())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParents() == null ? 0 : this.getParents().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListParentsResult clone() {
        try {
            return (ListParentsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

