/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.Instance;
import com.amazonaws.services.opsworks.model.transform.BlockDeviceMappingJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.ReportedOsJsonMarshaller;

public class InstanceJsonMarshaller {
    private static InstanceJsonMarshaller instance;

    public void marshall(Instance instance, StructuredJsonGenerator jsonGenerator) {
        if (instance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            SdkInternalList layerIdsList;
            SdkInternalList blockDeviceMappingsList;
            jsonGenerator.writeStartObject();
            if (instance.getAgentVersion() != null) {
                jsonGenerator.writeFieldName("AgentVersion").writeValue(instance.getAgentVersion());
            }
            if (instance.getAmiId() != null) {
                jsonGenerator.writeFieldName("AmiId").writeValue(instance.getAmiId());
            }
            if (instance.getArchitecture() != null) {
                jsonGenerator.writeFieldName("Architecture").writeValue(instance.getArchitecture());
            }
            if (instance.getAutoScalingType() != null) {
                jsonGenerator.writeFieldName("AutoScalingType").writeValue(instance.getAutoScalingType());
            }
            if (instance.getAvailabilityZone() != null) {
                jsonGenerator.writeFieldName("AvailabilityZone").writeValue(instance.getAvailabilityZone());
            }
            if (!(blockDeviceMappingsList = (SdkInternalList)instance.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("BlockDeviceMappings");
                jsonGenerator.writeStartArray();
                for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    if (blockDeviceMappingsListValue == null) continue;
                    BlockDeviceMappingJsonMarshaller.getInstance().marshall(blockDeviceMappingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (instance.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(instance.getCreatedAt());
            }
            if (instance.getEbsOptimized() != null) {
                jsonGenerator.writeFieldName("EbsOptimized").writeValue(instance.getEbsOptimized().booleanValue());
            }
            if (instance.getEc2InstanceId() != null) {
                jsonGenerator.writeFieldName("Ec2InstanceId").writeValue(instance.getEc2InstanceId());
            }
            if (instance.getEcsClusterArn() != null) {
                jsonGenerator.writeFieldName("EcsClusterArn").writeValue(instance.getEcsClusterArn());
            }
            if (instance.getEcsContainerInstanceArn() != null) {
                jsonGenerator.writeFieldName("EcsContainerInstanceArn").writeValue(instance.getEcsContainerInstanceArn());
            }
            if (instance.getElasticIp() != null) {
                jsonGenerator.writeFieldName("ElasticIp").writeValue(instance.getElasticIp());
            }
            if (instance.getHostname() != null) {
                jsonGenerator.writeFieldName("Hostname").writeValue(instance.getHostname());
            }
            if (instance.getInfrastructureClass() != null) {
                jsonGenerator.writeFieldName("InfrastructureClass").writeValue(instance.getInfrastructureClass());
            }
            if (instance.getInstallUpdatesOnBoot() != null) {
                jsonGenerator.writeFieldName("InstallUpdatesOnBoot").writeValue(instance.getInstallUpdatesOnBoot().booleanValue());
            }
            if (instance.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(instance.getInstanceId());
            }
            if (instance.getInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("InstanceProfileArn").writeValue(instance.getInstanceProfileArn());
            }
            if (instance.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(instance.getInstanceType());
            }
            if (instance.getLastServiceErrorId() != null) {
                jsonGenerator.writeFieldName("LastServiceErrorId").writeValue(instance.getLastServiceErrorId());
            }
            if (!(layerIdsList = (SdkInternalList)instance.getLayerIds()).isEmpty() || !layerIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("LayerIds");
                jsonGenerator.writeStartArray();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonGenerator.writeValue(layerIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (instance.getOs() != null) {
                jsonGenerator.writeFieldName("Os").writeValue(instance.getOs());
            }
            if (instance.getPlatform() != null) {
                jsonGenerator.writeFieldName("Platform").writeValue(instance.getPlatform());
            }
            if (instance.getPrivateDns() != null) {
                jsonGenerator.writeFieldName("PrivateDns").writeValue(instance.getPrivateDns());
            }
            if (instance.getPrivateIp() != null) {
                jsonGenerator.writeFieldName("PrivateIp").writeValue(instance.getPrivateIp());
            }
            if (instance.getPublicDns() != null) {
                jsonGenerator.writeFieldName("PublicDns").writeValue(instance.getPublicDns());
            }
            if (instance.getPublicIp() != null) {
                jsonGenerator.writeFieldName("PublicIp").writeValue(instance.getPublicIp());
            }
            if (instance.getRegisteredBy() != null) {
                jsonGenerator.writeFieldName("RegisteredBy").writeValue(instance.getRegisteredBy());
            }
            if (instance.getReportedAgentVersion() != null) {
                jsonGenerator.writeFieldName("ReportedAgentVersion").writeValue(instance.getReportedAgentVersion());
            }
            if (instance.getReportedOs() != null) {
                jsonGenerator.writeFieldName("ReportedOs");
                ReportedOsJsonMarshaller.getInstance().marshall(instance.getReportedOs(), jsonGenerator);
            }
            if (instance.getRootDeviceType() != null) {
                jsonGenerator.writeFieldName("RootDeviceType").writeValue(instance.getRootDeviceType());
            }
            if (instance.getRootDeviceVolumeId() != null) {
                jsonGenerator.writeFieldName("RootDeviceVolumeId").writeValue(instance.getRootDeviceVolumeId());
            }
            if (!(securityGroupIdsList = (SdkInternalList)instance.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (instance.getSshHostDsaKeyFingerprint() != null) {
                jsonGenerator.writeFieldName("SshHostDsaKeyFingerprint").writeValue(instance.getSshHostDsaKeyFingerprint());
            }
            if (instance.getSshHostRsaKeyFingerprint() != null) {
                jsonGenerator.writeFieldName("SshHostRsaKeyFingerprint").writeValue(instance.getSshHostRsaKeyFingerprint());
            }
            if (instance.getSshKeyName() != null) {
                jsonGenerator.writeFieldName("SshKeyName").writeValue(instance.getSshKeyName());
            }
            if (instance.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(instance.getStackId());
            }
            if (instance.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(instance.getStatus());
            }
            if (instance.getSubnetId() != null) {
                jsonGenerator.writeFieldName("SubnetId").writeValue(instance.getSubnetId());
            }
            if (instance.getTenancy() != null) {
                jsonGenerator.writeFieldName("Tenancy").writeValue(instance.getTenancy());
            }
            if (instance.getVirtualizationType() != null) {
                jsonGenerator.writeFieldName("VirtualizationType").writeValue(instance.getVirtualizationType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceJsonMarshaller();
        }
        return instance;
    }
}

