/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.CreateLayerRequest;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LifecycleEventConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.RecipesJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.VolumeConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateLayerRequestMarshaller
implements Marshaller<Request<CreateLayerRequest>, CreateLayerRequest> {
    public Request<CreateLayerRequest> marshall(CreateLayerRequest createLayerRequest) {
        if (createLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLayerRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateLayer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumeConfigurationsList;
            SdkInternalList packagesList;
            SdkInternalList customSecurityGroupIdsList;
            SdkInternalMap attributesMap;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (createLayerRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(createLayerRequest.getStackId());
            }
            if (createLayerRequest.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(createLayerRequest.getType());
            }
            if (createLayerRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createLayerRequest.getName());
            }
            if (createLayerRequest.getShortname() != null) {
                jsonGenerator.writeFieldName("Shortname").writeValue(createLayerRequest.getShortname());
            }
            if (!(attributesMap = (SdkInternalMap)createLayerRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Object attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)attributesMapValue.getKey());
                    jsonGenerator.writeValue((String)attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (createLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("CustomInstanceProfileArn").writeValue(createLayerRequest.getCustomInstanceProfileArn());
            }
            if (createLayerRequest.getCustomJson() != null) {
                jsonGenerator.writeFieldName("CustomJson").writeValue(createLayerRequest.getCustomJson());
            }
            if (!(customSecurityGroupIdsList = (SdkInternalList)createLayerRequest.getCustomSecurityGroupIds()).isEmpty() || !customSecurityGroupIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CustomSecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (Object customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue((String)customSecurityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(packagesList = (SdkInternalList)createLayerRequest.getPackages()).isEmpty() || !packagesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Packages");
                jsonGenerator.writeStartArray();
                for (Object packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonGenerator.writeValue((String)packagesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(volumeConfigurationsList = (SdkInternalList)createLayerRequest.getVolumeConfigurations()).isEmpty() || !volumeConfigurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("VolumeConfigurations");
                jsonGenerator.writeStartArray();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    VolumeConfigurationJsonMarshaller.getInstance().marshall(volumeConfigurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (createLayerRequest.getEnableAutoHealing() != null) {
                jsonGenerator.writeFieldName("EnableAutoHealing").writeValue(createLayerRequest.getEnableAutoHealing().booleanValue());
            }
            if (createLayerRequest.getAutoAssignElasticIps() != null) {
                jsonGenerator.writeFieldName("AutoAssignElasticIps").writeValue(createLayerRequest.getAutoAssignElasticIps().booleanValue());
            }
            if (createLayerRequest.getAutoAssignPublicIps() != null) {
                jsonGenerator.writeFieldName("AutoAssignPublicIps").writeValue(createLayerRequest.getAutoAssignPublicIps().booleanValue());
            }
            if (createLayerRequest.getCustomRecipes() != null) {
                jsonGenerator.writeFieldName("CustomRecipes");
                RecipesJsonMarshaller.getInstance().marshall(createLayerRequest.getCustomRecipes(), jsonGenerator);
            }
            if (createLayerRequest.getInstallUpdatesOnBoot() != null) {
                jsonGenerator.writeFieldName("InstallUpdatesOnBoot").writeValue(createLayerRequest.getInstallUpdatesOnBoot().booleanValue());
            }
            if (createLayerRequest.getUseEbsOptimizedInstances() != null) {
                jsonGenerator.writeFieldName("UseEbsOptimizedInstances").writeValue(createLayerRequest.getUseEbsOptimizedInstances().booleanValue());
            }
            if (createLayerRequest.getLifecycleEventConfiguration() != null) {
                jsonGenerator.writeFieldName("LifecycleEventConfiguration");
                LifecycleEventConfigurationJsonMarshaller.getInstance().marshall(createLayerRequest.getLifecycleEventConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

