/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.UpdateAppRequest;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class UpdateAppRequestMarshaller
implements Marshaller<Request<UpdateAppRequest>, UpdateAppRequest> {
    public Request<UpdateAppRequest> marshall(UpdateAppRequest updateAppRequest) {
        if (updateAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAppRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.UpdateApp");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateAppRequest.getAppId() != null) {
                jsonGenerator.writeFieldName("AppId").writeValue(updateAppRequest.getAppId());
            }
            if (updateAppRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateAppRequest.getName());
            }
            if (updateAppRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateAppRequest.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)updateAppRequest.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("DataSources");
                jsonGenerator.writeStartArray();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall(dataSourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateAppRequest.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(updateAppRequest.getType());
            }
            if (updateAppRequest.getAppSource() != null) {
                jsonGenerator.writeFieldName("AppSource");
                SourceJsonMarshaller.getInstance().marshall(updateAppRequest.getAppSource(), jsonGenerator);
            }
            if (!(domainsList = (SdkInternalList)updateAppRequest.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Domains");
                jsonGenerator.writeStartArray();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonGenerator.writeValue(domainsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateAppRequest.getEnableSsl() != null) {
                jsonGenerator.writeFieldName("EnableSsl").writeValue(updateAppRequest.getEnableSsl().booleanValue());
            }
            if (updateAppRequest.getSslConfiguration() != null) {
                jsonGenerator.writeFieldName("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(updateAppRequest.getSslConfiguration(), jsonGenerator);
            }
            if (!(attributesMap = (SdkInternalMap)updateAppRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Attributes");
                jsonGenerator.writeStartObject();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)attributesMapValue.getKey());
                    jsonGenerator.writeValue((String)attributesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(environmentList = (SdkInternalList)updateAppRequest.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Environment");
                jsonGenerator.writeStartArray();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

