/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.Instance;
import com.amazonaws.services.opsworks.model.transform.BlockDeviceMappingJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.ReportedOsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceJsonMarshaller {
    private static InstanceJsonMarshaller instance;

    public void marshall(Instance instance, JSONWriter jsonWriter) {
        if (instance == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList securityGroupIdsList;
            SdkInternalList layerIdsList;
            SdkInternalList blockDeviceMappingsList;
            jsonWriter.object();
            if (instance.getAgentVersion() != null) {
                jsonWriter.key("AgentVersion").value((Object)instance.getAgentVersion());
            }
            if (instance.getAmiId() != null) {
                jsonWriter.key("AmiId").value((Object)instance.getAmiId());
            }
            if (instance.getArchitecture() != null) {
                jsonWriter.key("Architecture").value((Object)instance.getArchitecture());
            }
            if (instance.getAutoScalingType() != null) {
                jsonWriter.key("AutoScalingType").value((Object)instance.getAutoScalingType());
            }
            if (instance.getAvailabilityZone() != null) {
                jsonWriter.key("AvailabilityZone").value((Object)instance.getAvailabilityZone());
            }
            if (!(blockDeviceMappingsList = (SdkInternalList)instance.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
                jsonWriter.key("BlockDeviceMappings");
                jsonWriter.array();
                for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    if (blockDeviceMappingsListValue == null) continue;
                    BlockDeviceMappingJsonMarshaller.getInstance().marshall(blockDeviceMappingsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (instance.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value((Object)instance.getCreatedAt());
            }
            if (instance.getEbsOptimized() != null) {
                jsonWriter.key("EbsOptimized").value((Object)instance.getEbsOptimized());
            }
            if (instance.getEc2InstanceId() != null) {
                jsonWriter.key("Ec2InstanceId").value((Object)instance.getEc2InstanceId());
            }
            if (instance.getEcsClusterArn() != null) {
                jsonWriter.key("EcsClusterArn").value((Object)instance.getEcsClusterArn());
            }
            if (instance.getEcsContainerInstanceArn() != null) {
                jsonWriter.key("EcsContainerInstanceArn").value((Object)instance.getEcsContainerInstanceArn());
            }
            if (instance.getElasticIp() != null) {
                jsonWriter.key("ElasticIp").value((Object)instance.getElasticIp());
            }
            if (instance.getHostname() != null) {
                jsonWriter.key("Hostname").value((Object)instance.getHostname());
            }
            if (instance.getInfrastructureClass() != null) {
                jsonWriter.key("InfrastructureClass").value((Object)instance.getInfrastructureClass());
            }
            if (instance.getInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)instance.getInstallUpdatesOnBoot());
            }
            if (instance.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value((Object)instance.getInstanceId());
            }
            if (instance.getInstanceProfileArn() != null) {
                jsonWriter.key("InstanceProfileArn").value((Object)instance.getInstanceProfileArn());
            }
            if (instance.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value((Object)instance.getInstanceType());
            }
            if (instance.getLastServiceErrorId() != null) {
                jsonWriter.key("LastServiceErrorId").value((Object)instance.getLastServiceErrorId());
            }
            if (!(layerIdsList = (SdkInternalList)instance.getLayerIds()).isEmpty() || !layerIdsList.isAutoConstruct()) {
                jsonWriter.key("LayerIds");
                jsonWriter.array();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonWriter.value((Object)layerIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (instance.getOs() != null) {
                jsonWriter.key("Os").value((Object)instance.getOs());
            }
            if (instance.getPlatform() != null) {
                jsonWriter.key("Platform").value((Object)instance.getPlatform());
            }
            if (instance.getPrivateDns() != null) {
                jsonWriter.key("PrivateDns").value((Object)instance.getPrivateDns());
            }
            if (instance.getPrivateIp() != null) {
                jsonWriter.key("PrivateIp").value((Object)instance.getPrivateIp());
            }
            if (instance.getPublicDns() != null) {
                jsonWriter.key("PublicDns").value((Object)instance.getPublicDns());
            }
            if (instance.getPublicIp() != null) {
                jsonWriter.key("PublicIp").value((Object)instance.getPublicIp());
            }
            if (instance.getRegisteredBy() != null) {
                jsonWriter.key("RegisteredBy").value((Object)instance.getRegisteredBy());
            }
            if (instance.getReportedAgentVersion() != null) {
                jsonWriter.key("ReportedAgentVersion").value((Object)instance.getReportedAgentVersion());
            }
            if (instance.getReportedOs() != null) {
                jsonWriter.key("ReportedOs");
                ReportedOsJsonMarshaller.getInstance().marshall(instance.getReportedOs(), jsonWriter);
            }
            if (instance.getRootDeviceType() != null) {
                jsonWriter.key("RootDeviceType").value((Object)instance.getRootDeviceType());
            }
            if (instance.getRootDeviceVolumeId() != null) {
                jsonWriter.key("RootDeviceVolumeId").value((Object)instance.getRootDeviceVolumeId());
            }
            if (!(securityGroupIdsList = (SdkInternalList)instance.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                jsonWriter.key("SecurityGroupIds");
                jsonWriter.array();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)securityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (instance.getSshHostDsaKeyFingerprint() != null) {
                jsonWriter.key("SshHostDsaKeyFingerprint").value((Object)instance.getSshHostDsaKeyFingerprint());
            }
            if (instance.getSshHostRsaKeyFingerprint() != null) {
                jsonWriter.key("SshHostRsaKeyFingerprint").value((Object)instance.getSshHostRsaKeyFingerprint());
            }
            if (instance.getSshKeyName() != null) {
                jsonWriter.key("SshKeyName").value((Object)instance.getSshKeyName());
            }
            if (instance.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)instance.getStackId());
            }
            if (instance.getStatus() != null) {
                jsonWriter.key("Status").value((Object)instance.getStatus());
            }
            if (instance.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)instance.getSubnetId());
            }
            if (instance.getVirtualizationType() != null) {
                jsonWriter.key("VirtualizationType").value((Object)instance.getVirtualizationType());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceJsonMarshaller();
        }
        return instance;
    }
}

