/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.CreateInstanceRequest;
import com.amazonaws.services.opsworks.model.EbsBlockDevice;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateInstanceRequestMarshaller
implements Marshaller<Request<CreateInstanceRequest>, CreateInstanceRequest> {
    public Request<CreateInstanceRequest> marshall(CreateInstanceRequest createInstanceRequest) {
        if (createInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateInstance";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag blockDeviceMappingsList;
            ListWithAutoConstructFlag layerIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createInstanceRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)createInstanceRequest.getStackId());
            }
            if (!((layerIdsList = (ListWithAutoConstructFlag)createInstanceRequest.getLayerIds()) == null || layerIdsList.isAutoConstruct() && layerIdsList.isEmpty())) {
                jsonWriter.key("LayerIds");
                jsonWriter.array();
                for (String layerIdsListValue : layerIdsList) {
                    if (layerIdsListValue == null) continue;
                    jsonWriter.value((Object)layerIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (createInstanceRequest.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value((Object)createInstanceRequest.getInstanceType());
            }
            if (createInstanceRequest.getAutoScalingType() != null) {
                jsonWriter.key("AutoScalingType").value((Object)createInstanceRequest.getAutoScalingType());
            }
            if (createInstanceRequest.getHostname() != null) {
                jsonWriter.key("Hostname").value((Object)createInstanceRequest.getHostname());
            }
            if (createInstanceRequest.getOs() != null) {
                jsonWriter.key("Os").value((Object)createInstanceRequest.getOs());
            }
            if (createInstanceRequest.getAmiId() != null) {
                jsonWriter.key("AmiId").value((Object)createInstanceRequest.getAmiId());
            }
            if (createInstanceRequest.getSshKeyName() != null) {
                jsonWriter.key("SshKeyName").value((Object)createInstanceRequest.getSshKeyName());
            }
            if (createInstanceRequest.getAvailabilityZone() != null) {
                jsonWriter.key("AvailabilityZone").value((Object)createInstanceRequest.getAvailabilityZone());
            }
            if (createInstanceRequest.getVirtualizationType() != null) {
                jsonWriter.key("VirtualizationType").value((Object)createInstanceRequest.getVirtualizationType());
            }
            if (createInstanceRequest.getSubnetId() != null) {
                jsonWriter.key("SubnetId").value((Object)createInstanceRequest.getSubnetId());
            }
            if (createInstanceRequest.getArchitecture() != null) {
                jsonWriter.key("Architecture").value((Object)createInstanceRequest.getArchitecture());
            }
            if (createInstanceRequest.getRootDeviceType() != null) {
                jsonWriter.key("RootDeviceType").value((Object)createInstanceRequest.getRootDeviceType());
            }
            if (!((blockDeviceMappingsList = (ListWithAutoConstructFlag)createInstanceRequest.getBlockDeviceMappings()) == null || blockDeviceMappingsList.isAutoConstruct() && blockDeviceMappingsList.isEmpty())) {
                jsonWriter.key("BlockDeviceMappings");
                jsonWriter.array();
                for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    EbsBlockDevice ebs;
                    if (blockDeviceMappingsListValue == null) continue;
                    jsonWriter.object();
                    if (blockDeviceMappingsListValue.getDeviceName() != null) {
                        jsonWriter.key("DeviceName").value((Object)blockDeviceMappingsListValue.getDeviceName());
                    }
                    if (blockDeviceMappingsListValue.getNoDevice() != null) {
                        jsonWriter.key("NoDevice").value((Object)blockDeviceMappingsListValue.getNoDevice());
                    }
                    if (blockDeviceMappingsListValue.getVirtualName() != null) {
                        jsonWriter.key("VirtualName").value((Object)blockDeviceMappingsListValue.getVirtualName());
                    }
                    if ((ebs = blockDeviceMappingsListValue.getEbs()) != null) {
                        jsonWriter.key("Ebs");
                        jsonWriter.object();
                        if (ebs.getSnapshotId() != null) {
                            jsonWriter.key("SnapshotId").value((Object)ebs.getSnapshotId());
                        }
                        if (ebs.getIops() != null) {
                            jsonWriter.key("Iops").value((Object)ebs.getIops());
                        }
                        if (ebs.getVolumeSize() != null) {
                            jsonWriter.key("VolumeSize").value((Object)ebs.getVolumeSize());
                        }
                        if (ebs.getVolumeType() != null) {
                            jsonWriter.key("VolumeType").value((Object)ebs.getVolumeType());
                        }
                        if (ebs.isDeleteOnTermination() != null) {
                            jsonWriter.key("DeleteOnTermination").value((Object)ebs.isDeleteOnTermination());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createInstanceRequest.isInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)createInstanceRequest.isInstallUpdatesOnBoot());
            }
            if (createInstanceRequest.isEbsOptimized() != null) {
                jsonWriter.key("EbsOptimized").value((Object)createInstanceRequest.isEbsOptimized());
            }
            if (createInstanceRequest.getAgentVersion() != null) {
                jsonWriter.key("AgentVersion").value((Object)createInstanceRequest.getAgentVersion());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

