/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.DescribeDeploymentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeDeploymentsRequestMarshaller
implements Marshaller<Request<DescribeDeploymentsRequest>, DescribeDeploymentsRequest> {
    public Request<DescribeDeploymentsRequest> marshall(DescribeDeploymentsRequest describeDeploymentsRequest) {
        if (describeDeploymentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDeploymentsRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeDeployments";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag deploymentIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (describeDeploymentsRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)describeDeploymentsRequest.getStackId());
            }
            if (describeDeploymentsRequest.getAppId() != null) {
                jsonWriter.key("AppId").value((Object)describeDeploymentsRequest.getAppId());
            }
            if (!((deploymentIdsList = (ListWithAutoConstructFlag)describeDeploymentsRequest.getDeploymentIds()) == null || deploymentIdsList.isAutoConstruct() && deploymentIdsList.isEmpty())) {
                jsonWriter.key("DeploymentIds");
                jsonWriter.array();
                for (String deploymentIdsListValue : deploymentIdsList) {
                    if (deploymentIdsListValue == null) continue;
                    jsonWriter.value((Object)deploymentIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

