/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.InboundConnection;

@SdkInternalApi
public class InboundConnectionMarshaller {
    private static final MarshallingInfo<StructuredPojo> LOCALDOMAININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalDomainInfo").build();
    private static final MarshallingInfo<StructuredPojo> REMOTEDOMAININFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RemoteDomainInfo").build();
    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionId").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionStatus").build();
    private static final MarshallingInfo<String> CONNECTIONMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionMode").build();
    private static final InboundConnectionMarshaller instance = new InboundConnectionMarshaller();

    public static InboundConnectionMarshaller getInstance() {
        return instance;
    }

    public void marshall(InboundConnection inboundConnection, ProtocolMarshaller protocolMarshaller) {
        if (inboundConnection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inboundConnection.getLocalDomainInfo(), LOCALDOMAININFO_BINDING);
            protocolMarshaller.marshall((Object)inboundConnection.getRemoteDomainInfo(), REMOTEDOMAININFO_BINDING);
            protocolMarshaller.marshall((Object)inboundConnection.getConnectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall((Object)inboundConnection.getConnectionStatus(), CONNECTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)inboundConnection.getConnectionMode(), CONNECTIONMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

