/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.opensearch.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AdvancedSecurityOptionsMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AdvancedSecurityOptionsMarshaller {

    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Enabled").build();
    private static final MarshallingInfo<Boolean> INTERNALUSERDATABASEENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InternalUserDatabaseEnabled").build();
    private static final MarshallingInfo<StructuredPojo> SAMLOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SAMLOptions").build();
    private static final MarshallingInfo<java.util.Date> ANONYMOUSAUTHDISABLEDATE_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnonymousAuthDisableDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> ANONYMOUSAUTHENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnonymousAuthEnabled").build();

    private static final AdvancedSecurityOptionsMarshaller instance = new AdvancedSecurityOptionsMarshaller();

    public static AdvancedSecurityOptionsMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AdvancedSecurityOptions advancedSecurityOptions, ProtocolMarshaller protocolMarshaller) {

        if (advancedSecurityOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(advancedSecurityOptions.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptions.getInternalUserDatabaseEnabled(), INTERNALUSERDATABASEENABLED_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptions.getSAMLOptions(), SAMLOPTIONS_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptions.getAnonymousAuthDisableDate(), ANONYMOUSAUTHDISABLEDATE_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptions.getAnonymousAuthEnabled(), ANONYMOUSAUTHENABLED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
