/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.PackageSource;

@SdkInternalApi
public class PackageSourceMarshaller {
    private static final MarshallingInfo<String> S3BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketName").build();
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Key").build();
    private static final PackageSourceMarshaller instance = new PackageSourceMarshaller();

    public static PackageSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageSource packageSource, ProtocolMarshaller protocolMarshaller) {
        if (packageSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)packageSource.getS3BucketName(), S3BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)packageSource.getS3Key(), S3KEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

