/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Use filters to focus the returned annotation store versions on a specific parameter, such as the status of the
 * annotation store.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersionsFilter"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListAnnotationStoreVersionsFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     */
    private String status;

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * 
     * @param status
     *        The status of an annotation store version.
     * @see VersionStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * 
     * @return The status of an annotation store version.
     * @see VersionStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * 
     * @param status
     *        The status of an annotation store version.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VersionStatus
     */

    public ListAnnotationStoreVersionsFilter withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * 
     * @param status
     *        The status of an annotation store version.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VersionStatus
     */

    public ListAnnotationStoreVersionsFilter withStatus(VersionStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListAnnotationStoreVersionsFilter == false)
            return false;
        ListAnnotationStoreVersionsFilter other = (ListAnnotationStoreVersionsFilter) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public ListAnnotationStoreVersionsFilter clone() {
        try {
            return (ListAnnotationStoreVersionsFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.omics.model.transform.ListAnnotationStoreVersionsFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
