/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;
import com.amazonaws.services.omics.model.ExportReadSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartReadSetExportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
SignerTypeAware {
    private String sequenceStoreId;
    private String destination;
    private String roleArn;
    private String clientToken;
    private List<ExportReadSet> sources;

    public void setSequenceStoreId(String sequenceStoreId) {
        this.sequenceStoreId = sequenceStoreId;
    }

    public String getSequenceStoreId() {
        return this.sequenceStoreId;
    }

    public StartReadSetExportJobRequest withSequenceStoreId(String sequenceStoreId) {
        this.setSequenceStoreId(sequenceStoreId);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public StartReadSetExportJobRequest withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public StartReadSetExportJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartReadSetExportJobRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<ExportReadSet> getSources() {
        return this.sources;
    }

    public void setSources(Collection<ExportReadSet> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<ExportReadSet>(sources);
    }

    public StartReadSetExportJobRequest withSources(ExportReadSet ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<ExportReadSet>(sources.length));
        }
        for (ExportReadSet ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public StartReadSetExportJobRequest withSources(Collection<ExportReadSet> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSequenceStoreId() != null) {
            sb.append("SequenceStoreId: ").append(this.getSequenceStoreId()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetExportJobRequest)) {
            return false;
        }
        StartReadSetExportJobRequest other = (StartReadSetExportJobRequest)obj;
        if (other.getSequenceStoreId() == null ^ this.getSequenceStoreId() == null) {
            return false;
        }
        if (other.getSequenceStoreId() != null && !other.getSequenceStoreId().equals(this.getSequenceStoreId())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSequenceStoreId() == null ? 0 : this.getSequenceStoreId().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public StartReadSetExportJobRequest clone() {
        return (StartReadSetExportJobRequest)super.clone();
    }

    public String getSignerType() {
        return "AWS4SignerType";
    }
}

