/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.omics.model.AnnotationType;
import com.amazonaws.services.omics.model.transform.TsvVersionOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TsvVersionOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String annotationType;
    private Map<String, String> formatToHeader;
    private List<Map<String, String>> schema;

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public TsvVersionOptions withAnnotationType(String annotationType) {
        this.setAnnotationType(annotationType);
        return this;
    }

    public TsvVersionOptions withAnnotationType(AnnotationType annotationType) {
        this.annotationType = annotationType.toString();
        return this;
    }

    public Map<String, String> getFormatToHeader() {
        return this.formatToHeader;
    }

    public void setFormatToHeader(Map<String, String> formatToHeader) {
        this.formatToHeader = formatToHeader;
    }

    public TsvVersionOptions withFormatToHeader(Map<String, String> formatToHeader) {
        this.setFormatToHeader(formatToHeader);
        return this;
    }

    public TsvVersionOptions addFormatToHeaderEntry(String key, String value) {
        if (null == this.formatToHeader) {
            this.formatToHeader = new HashMap<String, String>();
        }
        if (this.formatToHeader.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.formatToHeader.put(key, value);
        return this;
    }

    public TsvVersionOptions clearFormatToHeaderEntries() {
        this.formatToHeader = null;
        return this;
    }

    public List<Map<String, String>> getSchema() {
        return this.schema;
    }

    public void setSchema(Collection<Map<String, String>> schema) {
        if (schema == null) {
            this.schema = null;
            return;
        }
        this.schema = new ArrayList<Map<String, String>>(schema);
    }

    public TsvVersionOptions withSchema(Map<String, String> ... schema) {
        if (this.schema == null) {
            this.setSchema(new ArrayList<Map<String, String>>(schema.length));
        }
        for (Map<String, String> ele : schema) {
            this.schema.add(ele);
        }
        return this;
    }

    public TsvVersionOptions withSchema(Collection<Map<String, String>> schema) {
        this.setSchema(schema);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnnotationType() != null) {
            sb.append("AnnotationType: ").append(this.getAnnotationType()).append(",");
        }
        if (this.getFormatToHeader() != null) {
            sb.append("FormatToHeader: ").append(this.getFormatToHeader()).append(",");
        }
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TsvVersionOptions)) {
            return false;
        }
        TsvVersionOptions other = (TsvVersionOptions)obj;
        if (other.getAnnotationType() == null ^ this.getAnnotationType() == null) {
            return false;
        }
        if (other.getAnnotationType() != null && !other.getAnnotationType().equals(this.getAnnotationType())) {
            return false;
        }
        if (other.getFormatToHeader() == null ^ this.getFormatToHeader() == null) {
            return false;
        }
        if (other.getFormatToHeader() != null && !other.getFormatToHeader().equals(this.getFormatToHeader())) {
            return false;
        }
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        return other.getSchema() == null || other.getSchema().equals(this.getSchema());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnnotationType() == null ? 0 : this.getAnnotationType().hashCode());
        hashCode = 31 * hashCode + (this.getFormatToHeader() == null ? 0 : this.getFormatToHeader().hashCode());
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        return hashCode;
    }

    public TsvVersionOptions clone() {
        try {
            return (TsvVersionOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TsvVersionOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

