/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.omics.model.TaskListItem;
import java.util.Date;

@SdkInternalApi
public class TaskListItemMarshaller {
    private static final MarshallingInfo<Integer> CPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cpus").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Date> STOPTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stopTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskId").build();
    private static final TaskListItemMarshaller instance = new TaskListItemMarshaller();

    public static TaskListItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(TaskListItem taskListItem, ProtocolMarshaller protocolMarshaller) {
        if (taskListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)taskListItem.getCpus(), CPUS_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getMemory(), MEMORY_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getStopTime(), STOPTIME_BINDING);
            protocolMarshaller.marshall((Object)taskListItem.getTaskId(), TASKID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

