/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.nimblestudio.model.ScriptParameterKeyValue;
import com.amazonaws.services.nimblestudio.model.StudioComponentConfiguration;
import com.amazonaws.services.nimblestudio.model.StudioComponentInitializationScript;
import com.amazonaws.services.nimblestudio.model.StudioComponentSubtype;
import com.amazonaws.services.nimblestudio.model.StudioComponentType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateStudioComponentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private StudioComponentConfiguration configuration;
    private String description;
    private List<String> ec2SecurityGroupIds;
    private List<StudioComponentInitializationScript> initializationScripts;
    private String name;
    private List<ScriptParameterKeyValue> scriptParameters;
    private String studioId;
    private String subtype;
    private Map<String, String> tags;
    private String type;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateStudioComponentRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setConfiguration(StudioComponentConfiguration configuration) {
        this.configuration = configuration;
    }

    public StudioComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateStudioComponentRequest withConfiguration(StudioComponentConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateStudioComponentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getEc2SecurityGroupIds() {
        return this.ec2SecurityGroupIds;
    }

    public void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
        if (ec2SecurityGroupIds == null) {
            this.ec2SecurityGroupIds = null;
            return;
        }
        this.ec2SecurityGroupIds = new ArrayList<String>(ec2SecurityGroupIds);
    }

    public CreateStudioComponentRequest withEc2SecurityGroupIds(String ... ec2SecurityGroupIds) {
        if (this.ec2SecurityGroupIds == null) {
            this.setEc2SecurityGroupIds(new ArrayList<String>(ec2SecurityGroupIds.length));
        }
        for (String ele : ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds.add(ele);
        }
        return this;
    }

    public CreateStudioComponentRequest withEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
        this.setEc2SecurityGroupIds(ec2SecurityGroupIds);
        return this;
    }

    public List<StudioComponentInitializationScript> getInitializationScripts() {
        return this.initializationScripts;
    }

    public void setInitializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
        if (initializationScripts == null) {
            this.initializationScripts = null;
            return;
        }
        this.initializationScripts = new ArrayList<StudioComponentInitializationScript>(initializationScripts);
    }

    public CreateStudioComponentRequest withInitializationScripts(StudioComponentInitializationScript ... initializationScripts) {
        if (this.initializationScripts == null) {
            this.setInitializationScripts(new ArrayList<StudioComponentInitializationScript>(initializationScripts.length));
        }
        for (StudioComponentInitializationScript ele : initializationScripts) {
            this.initializationScripts.add(ele);
        }
        return this;
    }

    public CreateStudioComponentRequest withInitializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
        this.setInitializationScripts(initializationScripts);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateStudioComponentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<ScriptParameterKeyValue> getScriptParameters() {
        return this.scriptParameters;
    }

    public void setScriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
        if (scriptParameters == null) {
            this.scriptParameters = null;
            return;
        }
        this.scriptParameters = new ArrayList<ScriptParameterKeyValue>(scriptParameters);
    }

    public CreateStudioComponentRequest withScriptParameters(ScriptParameterKeyValue ... scriptParameters) {
        if (this.scriptParameters == null) {
            this.setScriptParameters(new ArrayList<ScriptParameterKeyValue>(scriptParameters.length));
        }
        for (ScriptParameterKeyValue ele : scriptParameters) {
            this.scriptParameters.add(ele);
        }
        return this;
    }

    public CreateStudioComponentRequest withScriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
        this.setScriptParameters(scriptParameters);
        return this;
    }

    public void setStudioId(String studioId) {
        this.studioId = studioId;
    }

    public String getStudioId() {
        return this.studioId;
    }

    public CreateStudioComponentRequest withStudioId(String studioId) {
        this.setStudioId(studioId);
        return this;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public CreateStudioComponentRequest withSubtype(String subtype) {
        this.setSubtype(subtype);
        return this;
    }

    public CreateStudioComponentRequest withSubtype(StudioComponentSubtype subtype) {
        this.subtype = subtype.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateStudioComponentRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateStudioComponentRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateStudioComponentRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateStudioComponentRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateStudioComponentRequest withType(StudioComponentType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEc2SecurityGroupIds() != null) {
            sb.append("Ec2SecurityGroupIds: ").append(this.getEc2SecurityGroupIds()).append(",");
        }
        if (this.getInitializationScripts() != null) {
            sb.append("InitializationScripts: ").append(this.getInitializationScripts()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getScriptParameters() != null) {
            sb.append("ScriptParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStudioId() != null) {
            sb.append("StudioId: ").append(this.getStudioId()).append(",");
        }
        if (this.getSubtype() != null) {
            sb.append("Subtype: ").append(this.getSubtype()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioComponentRequest)) {
            return false;
        }
        CreateStudioComponentRequest other = (CreateStudioComponentRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEc2SecurityGroupIds() == null ^ this.getEc2SecurityGroupIds() == null) {
            return false;
        }
        if (other.getEc2SecurityGroupIds() != null && !other.getEc2SecurityGroupIds().equals(this.getEc2SecurityGroupIds())) {
            return false;
        }
        if (other.getInitializationScripts() == null ^ this.getInitializationScripts() == null) {
            return false;
        }
        if (other.getInitializationScripts() != null && !other.getInitializationScripts().equals(this.getInitializationScripts())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScriptParameters() == null ^ this.getScriptParameters() == null) {
            return false;
        }
        if (other.getScriptParameters() != null && !other.getScriptParameters().equals(this.getScriptParameters())) {
            return false;
        }
        if (other.getStudioId() == null ^ this.getStudioId() == null) {
            return false;
        }
        if (other.getStudioId() != null && !other.getStudioId().equals(this.getStudioId())) {
            return false;
        }
        if (other.getSubtype() == null ^ this.getSubtype() == null) {
            return false;
        }
        if (other.getSubtype() != null && !other.getSubtype().equals(this.getSubtype())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SecurityGroupIds() == null ? 0 : this.getEc2SecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getInitializationScripts() == null ? 0 : this.getInitializationScripts().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScriptParameters() == null ? 0 : this.getScriptParameters().hashCode());
        hashCode = 31 * hashCode + (this.getStudioId() == null ? 0 : this.getStudioId().hashCode());
        hashCode = 31 * hashCode + (this.getSubtype() == null ? 0 : this.getSubtype().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public CreateStudioComponentRequest clone() {
        return (CreateStudioComponentRequest)super.clone();
    }
}

