/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.Site;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SiteMarshaller {
    private static final MarshallingInfo<String> SITEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SiteId").build();
    private static final MarshallingInfo<String> SITEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SiteArn").build();
    private static final MarshallingInfo<String> GLOBALNETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalNetworkId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Location").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final SiteMarshaller instance = new SiteMarshaller();

    public static SiteMarshaller getInstance() {
        return instance;
    }

    public void marshall(Site site, ProtocolMarshaller protocolMarshaller) {
        if (site == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)site.getSiteId(), SITEID_BINDING);
            protocolMarshaller.marshall((Object)site.getSiteArn(), SITEARN_BINDING);
            protocolMarshaller.marshall((Object)site.getGlobalNetworkId(), GLOBALNETWORKID_BINDING);
            protocolMarshaller.marshall((Object)site.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)site.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)site.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)site.getState(), STATE_BINDING);
            protocolMarshaller.marshall(site.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

