/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager;

import javax.annotation.Generated;

import com.amazonaws.services.networkmanager.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSNetworkManager}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSNetworkManager implements AWSNetworkManager {

    protected AbstractAWSNetworkManager() {
    }

    @Override
    public AcceptAttachmentResult acceptAttachment(AcceptAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateConnectPeerResult associateConnectPeer(AssociateConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateCustomerGatewayResult associateCustomerGateway(AssociateCustomerGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateLinkResult associateLink(AssociateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateTransitGatewayConnectPeerResult associateTransitGatewayConnectPeer(AssociateTransitGatewayConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectAttachmentResult createConnectAttachment(CreateConnectAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectPeerResult createConnectPeer(CreateConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCoreNetworkResult createCoreNetwork(CreateCoreNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDeviceResult createDevice(CreateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGlobalNetworkResult createGlobalNetwork(CreateGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLinkResult createLink(CreateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSiteResult createSite(CreateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSiteToSiteVpnAttachmentResult createSiteToSiteVpnAttachment(CreateSiteToSiteVpnAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransitGatewayPeeringResult createTransitGatewayPeering(CreateTransitGatewayPeeringRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTransitGatewayRouteTableAttachmentResult createTransitGatewayRouteTableAttachment(CreateTransitGatewayRouteTableAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVpcAttachmentResult createVpcAttachment(CreateVpcAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAttachmentResult deleteAttachment(DeleteAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectPeerResult deleteConnectPeer(DeleteConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCoreNetworkResult deleteCoreNetwork(DeleteCoreNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCoreNetworkPolicyVersionResult deleteCoreNetworkPolicyVersion(DeleteCoreNetworkPolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDeviceResult deleteDevice(DeleteDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGlobalNetworkResult deleteGlobalNetwork(DeleteGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLinkResult deleteLink(DeleteLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePeeringResult deletePeering(DeletePeeringRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSiteResult deleteSite(DeleteSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterTransitGatewayResult deregisterTransitGateway(DeregisterTransitGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGlobalNetworksResult describeGlobalNetworks(DescribeGlobalNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateConnectPeerResult disassociateConnectPeer(DisassociateConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateCustomerGatewayResult disassociateCustomerGateway(DisassociateCustomerGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateLinkResult disassociateLink(DisassociateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateTransitGatewayConnectPeerResult disassociateTransitGatewayConnectPeer(DisassociateTransitGatewayConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteCoreNetworkChangeSetResult executeCoreNetworkChangeSet(ExecuteCoreNetworkChangeSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectAttachmentResult getConnectAttachment(GetConnectAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectPeerResult getConnectPeer(GetConnectPeerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectPeerAssociationsResult getConnectPeerAssociations(GetConnectPeerAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectionsResult getConnections(GetConnectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreNetworkResult getCoreNetwork(GetCoreNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreNetworkChangeEventsResult getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreNetworkChangeSetResult getCoreNetworkChangeSet(GetCoreNetworkChangeSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCoreNetworkPolicyResult getCoreNetworkPolicy(GetCoreNetworkPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCustomerGatewayAssociationsResult getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDevicesResult getDevices(GetDevicesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLinkAssociationsResult getLinkAssociations(GetLinkAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLinksResult getLinks(GetLinksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResourceCountsResult getNetworkResourceCounts(GetNetworkResourceCountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResourceRelationshipsResult getNetworkResourceRelationships(GetNetworkResourceRelationshipsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkResourcesResult getNetworkResources(GetNetworkResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkRoutesResult getNetworkRoutes(GetNetworkRoutesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetNetworkTelemetryResult getNetworkTelemetry(GetNetworkTelemetryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourcePolicyResult getResourcePolicy(GetResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRouteAnalysisResult getRouteAnalysis(GetRouteAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSiteToSiteVpnAttachmentResult getSiteToSiteVpnAttachment(GetSiteToSiteVpnAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSitesResult getSites(GetSitesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransitGatewayConnectPeerAssociationsResult getTransitGatewayConnectPeerAssociations(GetTransitGatewayConnectPeerAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransitGatewayPeeringResult getTransitGatewayPeering(GetTransitGatewayPeeringRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransitGatewayRegistrationsResult getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTransitGatewayRouteTableAttachmentResult getTransitGatewayRouteTableAttachment(GetTransitGatewayRouteTableAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVpcAttachmentResult getVpcAttachment(GetVpcAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAttachmentsResult listAttachments(ListAttachmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectPeersResult listConnectPeers(ListConnectPeersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoreNetworkPolicyVersionsResult listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCoreNetworksResult listCoreNetworks(ListCoreNetworksRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationServiceAccessStatusResult listOrganizationServiceAccessStatus(ListOrganizationServiceAccessStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPeeringsResult listPeerings(ListPeeringsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutCoreNetworkPolicyResult putCoreNetworkPolicy(PutCoreNetworkPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterTransitGatewayResult registerTransitGateway(RegisterTransitGatewayRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RejectAttachmentResult rejectAttachment(RejectAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestoreCoreNetworkPolicyVersionResult restoreCoreNetworkPolicyVersion(RestoreCoreNetworkPolicyVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartOrganizationServiceAccessUpdateResult startOrganizationServiceAccessUpdate(StartOrganizationServiceAccessUpdateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartRouteAnalysisResult startRouteAnalysis(StartRouteAnalysisRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConnectionResult updateConnection(UpdateConnectionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCoreNetworkResult updateCoreNetwork(UpdateCoreNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDeviceResult updateDevice(UpdateDeviceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlobalNetworkResult updateGlobalNetwork(UpdateGlobalNetworkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateLinkResult updateLink(UpdateLinkRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateNetworkResourceMetadataResult updateNetworkResourceMetadata(UpdateNetworkResourceMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSiteResult updateSite(UpdateSiteRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVpcAttachmentResult updateVpcAttachment(UpdateVpcAttachmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
