/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.TCPFlag;
import com.amazonaws.services.networkfirewall.model.transform.TCPFlagFieldMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TCPFlagField
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> flags;
    private List<String> masks;

    public List<String> getFlags() {
        return this.flags;
    }

    public void setFlags(Collection<String> flags) {
        if (flags == null) {
            this.flags = null;
            return;
        }
        this.flags = new ArrayList<String>(flags);
    }

    public TCPFlagField withFlags(String ... flags) {
        if (this.flags == null) {
            this.setFlags(new ArrayList<String>(flags.length));
        }
        for (String ele : flags) {
            this.flags.add(ele);
        }
        return this;
    }

    public TCPFlagField withFlags(Collection<String> flags) {
        this.setFlags(flags);
        return this;
    }

    public TCPFlagField withFlags(TCPFlag ... flags) {
        ArrayList<String> flagsCopy = new ArrayList<String>(flags.length);
        for (TCPFlag value : flags) {
            flagsCopy.add(value.toString());
        }
        if (this.getFlags() == null) {
            this.setFlags(flagsCopy);
        } else {
            this.getFlags().addAll(flagsCopy);
        }
        return this;
    }

    public List<String> getMasks() {
        return this.masks;
    }

    public void setMasks(Collection<String> masks) {
        if (masks == null) {
            this.masks = null;
            return;
        }
        this.masks = new ArrayList<String>(masks);
    }

    public TCPFlagField withMasks(String ... masks) {
        if (this.masks == null) {
            this.setMasks(new ArrayList<String>(masks.length));
        }
        for (String ele : masks) {
            this.masks.add(ele);
        }
        return this;
    }

    public TCPFlagField withMasks(Collection<String> masks) {
        this.setMasks(masks);
        return this;
    }

    public TCPFlagField withMasks(TCPFlag ... masks) {
        ArrayList<String> masksCopy = new ArrayList<String>(masks.length);
        for (TCPFlag value : masks) {
            masksCopy.add(value.toString());
        }
        if (this.getMasks() == null) {
            this.setMasks(masksCopy);
        } else {
            this.getMasks().addAll(masksCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFlags() != null) {
            sb.append("Flags: ").append(this.getFlags()).append(",");
        }
        if (this.getMasks() != null) {
            sb.append("Masks: ").append(this.getMasks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TCPFlagField)) {
            return false;
        }
        TCPFlagField other = (TCPFlagField)obj;
        if (other.getFlags() == null ^ this.getFlags() == null) {
            return false;
        }
        if (other.getFlags() != null && !other.getFlags().equals(this.getFlags())) {
            return false;
        }
        if (other.getMasks() == null ^ this.getMasks() == null) {
            return false;
        }
        return other.getMasks() == null || other.getMasks().equals(this.getMasks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFlags() == null ? 0 : this.getFlags().hashCode());
        hashCode = 31 * hashCode + (this.getMasks() == null ? 0 : this.getMasks().hashCode());
        return hashCode;
    }

    public TCPFlagField clone() {
        try {
            return (TCPFlagField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TCPFlagFieldMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

