/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.Attachment;
import com.amazonaws.services.networkfirewall.model.PerObjectStatus;
import com.amazonaws.services.networkfirewall.model.transform.SyncStateMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SyncState
implements Serializable,
Cloneable,
StructuredPojo {
    private Attachment attachment;
    private Map<String, PerObjectStatus> config;

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public SyncState withAttachment(Attachment attachment) {
        this.setAttachment(attachment);
        return this;
    }

    public Map<String, PerObjectStatus> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, PerObjectStatus> config) {
        this.config = config;
    }

    public SyncState withConfig(Map<String, PerObjectStatus> config) {
        this.setConfig(config);
        return this;
    }

    public SyncState addConfigEntry(String key, PerObjectStatus value) {
        if (null == this.config) {
            this.config = new HashMap<String, PerObjectStatus>();
        }
        if (this.config.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.config.put(key, value);
        return this;
    }

    public SyncState clearConfigEntries() {
        this.config = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachment() != null) {
            sb.append("Attachment: ").append(this.getAttachment()).append(",");
        }
        if (this.getConfig() != null) {
            sb.append("Config: ").append(this.getConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncState)) {
            return false;
        }
        SyncState other = (SyncState)obj;
        if (other.getAttachment() == null ^ this.getAttachment() == null) {
            return false;
        }
        if (other.getAttachment() != null && !other.getAttachment().equals(this.getAttachment())) {
            return false;
        }
        if (other.getConfig() == null ^ this.getConfig() == null) {
            return false;
        }
        return other.getConfig() == null || other.getConfig().equals(this.getConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachment() == null ? 0 : this.getAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getConfig() == null ? 0 : this.getConfig().hashCode());
        return hashCode;
    }

    public SyncState clone() {
        try {
            return (SyncState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SyncStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

