/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ExecuteFastResetRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable, SignerTypeAware {

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     */
    private String action;
    /**
     * <p>
     * The fast-reset token to initiate the reset.
     * </p>
     */
    private String token;

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * 
     * @param action
     *        The fast reset action. One of the following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *        perform the fast reset.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *        <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *        </p>
     *        <p/></li>
     * @see Action
     */

    public void setAction(String action) {
        this.action = action;
    }

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * 
     * @return The fast reset action. One of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *         perform the fast reset.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *         <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *         </p>
     *         <p/></li>
     * @see Action
     */

    public String getAction() {
        return this.action;
    }

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * 
     * @param action
     *        The fast reset action. One of the following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *        perform the fast reset.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *        <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *        </p>
     *        <p/></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Action
     */

    public ExecuteFastResetRequest withAction(String action) {
        setAction(action);
        return this;
    }

    /**
     * <p>
     * The fast reset action. One of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually perform
     * the fast reset.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     * <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     * </p>
     * <p/></li>
     * </ul>
     * 
     * @param action
     *        The fast reset action. One of the following values:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <b> <code>initiateDatabaseReset</code> </b>   –   This action generates a unique token needed to actually
     *        perform the fast reset.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <b> <code>performDatabaseReset</code> </b>   –   This action uses the token generated by the
     *        <code>initiateDatabaseReset</code> action to actually perform the fast reset.
     *        </p>
     *        <p/></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Action
     */

    public ExecuteFastResetRequest withAction(Action action) {
        this.action = action.toString();
        return this;
    }

    /**
     * <p>
     * The fast-reset token to initiate the reset.
     * </p>
     * 
     * @param token
     *        The fast-reset token to initiate the reset.
     */

    public void setToken(String token) {
        this.token = token;
    }

    /**
     * <p>
     * The fast-reset token to initiate the reset.
     * </p>
     * 
     * @return The fast-reset token to initiate the reset.
     */

    public String getToken() {
        return this.token;
    }

    /**
     * <p>
     * The fast-reset token to initiate the reset.
     * </p>
     * 
     * @param token
     *        The fast-reset token to initiate the reset.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ExecuteFastResetRequest withToken(String token) {
        setToken(token);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAction() != null)
            sb.append("Action: ").append(getAction()).append(",");
        if (getToken() != null)
            sb.append("Token: ").append(getToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ExecuteFastResetRequest == false)
            return false;
        ExecuteFastResetRequest other = (ExecuteFastResetRequest) obj;
        if (other.getAction() == null ^ this.getAction() == null)
            return false;
        if (other.getAction() != null && other.getAction().equals(this.getAction()) == false)
            return false;
        if (other.getToken() == null ^ this.getToken() == null)
            return false;
        if (other.getToken() != null && other.getToken().equals(this.getToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAction() == null) ? 0 : getAction().hashCode());
        hashCode = prime * hashCode + ((getToken() == null) ? 0 : getToken().hashCode());
        return hashCode;
    }

    @Override
    public ExecuteFastResetRequest clone() {
        return (ExecuteFastResetRequest) super.clone();
    }

    @Override
    public String getSignerType() {
        return "AWS4SignerType";
    }

}
