/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mwaa.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mwaa.model.StatisticSet;

@SdkInternalApi
public class StatisticSetMarshaller {
    private static final MarshallingInfo<Double> MAXIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Maximum").build();
    private static final MarshallingInfo<Double> MINIMUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Minimum").build();
    private static final MarshallingInfo<Integer> SAMPLECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleCount").build();
    private static final MarshallingInfo<Double> SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sum").build();
    private static final StatisticSetMarshaller instance = new StatisticSetMarshaller();

    public static StatisticSetMarshaller getInstance() {
        return instance;
    }

    public void marshall(StatisticSet statisticSet, ProtocolMarshaller protocolMarshaller) {
        if (statisticSet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)statisticSet.getMaximum(), MAXIMUM_BINDING);
            protocolMarshaller.marshall((Object)statisticSet.getMinimum(), MINIMUM_BINDING);
            protocolMarshaller.marshall((Object)statisticSet.getSampleCount(), SAMPLECOUNT_BINDING);
            protocolMarshaller.marshall((Object)statisticSet.getSum(), SUM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

