/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mq.AmazonMQAsync;
import com.amazonaws.services.mq.AmazonMQAsyncClientBuilder;
import com.amazonaws.services.mq.AmazonMQClient;
import com.amazonaws.services.mq.model.CreateBrokerRequest;
import com.amazonaws.services.mq.model.CreateBrokerResult;
import com.amazonaws.services.mq.model.CreateConfigurationRequest;
import com.amazonaws.services.mq.model.CreateConfigurationResult;
import com.amazonaws.services.mq.model.CreateTagsRequest;
import com.amazonaws.services.mq.model.CreateTagsResult;
import com.amazonaws.services.mq.model.CreateUserRequest;
import com.amazonaws.services.mq.model.CreateUserResult;
import com.amazonaws.services.mq.model.DeleteBrokerRequest;
import com.amazonaws.services.mq.model.DeleteBrokerResult;
import com.amazonaws.services.mq.model.DeleteTagsRequest;
import com.amazonaws.services.mq.model.DeleteTagsResult;
import com.amazonaws.services.mq.model.DeleteUserRequest;
import com.amazonaws.services.mq.model.DeleteUserResult;
import com.amazonaws.services.mq.model.DescribeBrokerEngineTypesRequest;
import com.amazonaws.services.mq.model.DescribeBrokerEngineTypesResult;
import com.amazonaws.services.mq.model.DescribeBrokerInstanceOptionsRequest;
import com.amazonaws.services.mq.model.DescribeBrokerInstanceOptionsResult;
import com.amazonaws.services.mq.model.DescribeBrokerRequest;
import com.amazonaws.services.mq.model.DescribeBrokerResult;
import com.amazonaws.services.mq.model.DescribeConfigurationRequest;
import com.amazonaws.services.mq.model.DescribeConfigurationResult;
import com.amazonaws.services.mq.model.DescribeConfigurationRevisionRequest;
import com.amazonaws.services.mq.model.DescribeConfigurationRevisionResult;
import com.amazonaws.services.mq.model.DescribeUserRequest;
import com.amazonaws.services.mq.model.DescribeUserResult;
import com.amazonaws.services.mq.model.ListBrokersRequest;
import com.amazonaws.services.mq.model.ListBrokersResult;
import com.amazonaws.services.mq.model.ListConfigurationRevisionsRequest;
import com.amazonaws.services.mq.model.ListConfigurationRevisionsResult;
import com.amazonaws.services.mq.model.ListConfigurationsRequest;
import com.amazonaws.services.mq.model.ListConfigurationsResult;
import com.amazonaws.services.mq.model.ListTagsRequest;
import com.amazonaws.services.mq.model.ListTagsResult;
import com.amazonaws.services.mq.model.ListUsersRequest;
import com.amazonaws.services.mq.model.ListUsersResult;
import com.amazonaws.services.mq.model.RebootBrokerRequest;
import com.amazonaws.services.mq.model.RebootBrokerResult;
import com.amazonaws.services.mq.model.UpdateBrokerRequest;
import com.amazonaws.services.mq.model.UpdateBrokerResult;
import com.amazonaws.services.mq.model.UpdateConfigurationRequest;
import com.amazonaws.services.mq.model.UpdateConfigurationResult;
import com.amazonaws.services.mq.model.UpdateUserRequest;
import com.amazonaws.services.mq.model.UpdateUserResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMQAsyncClient
extends AmazonMQClient
implements AmazonMQAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMQAsyncClientBuilder asyncBuilder() {
        return AmazonMQAsyncClientBuilder.standard();
    }

    AmazonMQAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonMQAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateBrokerResult> createBrokerAsync(CreateBrokerRequest request) {
        return this.createBrokerAsync(request, null);
    }

    @Override
    public Future<CreateBrokerResult> createBrokerAsync(CreateBrokerRequest request, final AsyncHandler<CreateBrokerRequest, CreateBrokerResult> asyncHandler) {
        final CreateBrokerRequest finalRequest = (CreateBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBrokerResult>(){

            @Override
            public CreateBrokerResult call() throws Exception {
                CreateBrokerResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeCreateBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request) {
        return this.createConfigurationAsync(request, null);
    }

    @Override
    public Future<CreateConfigurationResult> createConfigurationAsync(CreateConfigurationRequest request, final AsyncHandler<CreateConfigurationRequest, CreateConfigurationResult> asyncHandler) {
        final CreateConfigurationRequest finalRequest = (CreateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConfigurationResult>(){

            @Override
            public CreateConfigurationResult call() throws Exception {
                CreateConfigurationResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeCreateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request) {
        return this.createUserAsync(request, null);
    }

    @Override
    public Future<CreateUserResult> createUserAsync(CreateUserRequest request, final AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {
        final CreateUserRequest finalRequest = (CreateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserResult>(){

            @Override
            public CreateUserResult call() throws Exception {
                CreateUserResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeCreateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBrokerResult> deleteBrokerAsync(DeleteBrokerRequest request) {
        return this.deleteBrokerAsync(request, null);
    }

    @Override
    public Future<DeleteBrokerResult> deleteBrokerAsync(DeleteBrokerRequest request, final AsyncHandler<DeleteBrokerRequest, DeleteBrokerResult> asyncHandler) {
        final DeleteBrokerRequest finalRequest = (DeleteBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBrokerResult>(){

            @Override
            public DeleteBrokerResult call() throws Exception {
                DeleteBrokerResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDeleteBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        final DeleteUserRequest finalRequest = (DeleteUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDeleteUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBrokerResult> describeBrokerAsync(DescribeBrokerRequest request) {
        return this.describeBrokerAsync(request, null);
    }

    @Override
    public Future<DescribeBrokerResult> describeBrokerAsync(DescribeBrokerRequest request, final AsyncHandler<DescribeBrokerRequest, DescribeBrokerResult> asyncHandler) {
        final DescribeBrokerRequest finalRequest = (DescribeBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBrokerResult>(){

            @Override
            public DescribeBrokerResult call() throws Exception {
                DescribeBrokerResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBrokerEngineTypesResult> describeBrokerEngineTypesAsync(DescribeBrokerEngineTypesRequest request) {
        return this.describeBrokerEngineTypesAsync(request, null);
    }

    @Override
    public Future<DescribeBrokerEngineTypesResult> describeBrokerEngineTypesAsync(DescribeBrokerEngineTypesRequest request, final AsyncHandler<DescribeBrokerEngineTypesRequest, DescribeBrokerEngineTypesResult> asyncHandler) {
        final DescribeBrokerEngineTypesRequest finalRequest = (DescribeBrokerEngineTypesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBrokerEngineTypesResult>(){

            @Override
            public DescribeBrokerEngineTypesResult call() throws Exception {
                DescribeBrokerEngineTypesResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeBrokerEngineTypes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBrokerInstanceOptionsResult> describeBrokerInstanceOptionsAsync(DescribeBrokerInstanceOptionsRequest request) {
        return this.describeBrokerInstanceOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeBrokerInstanceOptionsResult> describeBrokerInstanceOptionsAsync(DescribeBrokerInstanceOptionsRequest request, final AsyncHandler<DescribeBrokerInstanceOptionsRequest, DescribeBrokerInstanceOptionsResult> asyncHandler) {
        final DescribeBrokerInstanceOptionsRequest finalRequest = (DescribeBrokerInstanceOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBrokerInstanceOptionsResult>(){

            @Override
            public DescribeBrokerInstanceOptionsResult call() throws Exception {
                DescribeBrokerInstanceOptionsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeBrokerInstanceOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request) {
        return this.describeConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationResult> describeConfigurationAsync(DescribeConfigurationRequest request, final AsyncHandler<DescribeConfigurationRequest, DescribeConfigurationResult> asyncHandler) {
        final DescribeConfigurationRequest finalRequest = (DescribeConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationResult>(){

            @Override
            public DescribeConfigurationResult call() throws Exception {
                DescribeConfigurationResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request) {
        return this.describeConfigurationRevisionAsync(request, null);
    }

    @Override
    public Future<DescribeConfigurationRevisionResult> describeConfigurationRevisionAsync(DescribeConfigurationRevisionRequest request, final AsyncHandler<DescribeConfigurationRevisionRequest, DescribeConfigurationRevisionResult> asyncHandler) {
        final DescribeConfigurationRevisionRequest finalRequest = (DescribeConfigurationRevisionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConfigurationRevisionResult>(){

            @Override
            public DescribeConfigurationRevisionResult call() throws Exception {
                DescribeConfigurationRevisionResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeConfigurationRevision(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request) {
        return this.describeUserAsync(request, null);
    }

    @Override
    public Future<DescribeUserResult> describeUserAsync(DescribeUserRequest request, final AsyncHandler<DescribeUserRequest, DescribeUserResult> asyncHandler) {
        final DescribeUserRequest finalRequest = (DescribeUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserResult>(){

            @Override
            public DescribeUserResult call() throws Exception {
                DescribeUserResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeDescribeUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBrokersResult> listBrokersAsync(ListBrokersRequest request) {
        return this.listBrokersAsync(request, null);
    }

    @Override
    public Future<ListBrokersResult> listBrokersAsync(ListBrokersRequest request, final AsyncHandler<ListBrokersRequest, ListBrokersResult> asyncHandler) {
        final ListBrokersRequest finalRequest = (ListBrokersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBrokersResult>(){

            @Override
            public ListBrokersResult call() throws Exception {
                ListBrokersResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeListBrokers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request) {
        return this.listConfigurationRevisionsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationRevisionsResult> listConfigurationRevisionsAsync(ListConfigurationRevisionsRequest request, final AsyncHandler<ListConfigurationRevisionsRequest, ListConfigurationRevisionsResult> asyncHandler) {
        final ListConfigurationRevisionsRequest finalRequest = (ListConfigurationRevisionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationRevisionsResult>(){

            @Override
            public ListConfigurationRevisionsResult call() throws Exception {
                ListConfigurationRevisionsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeListConfigurationRevisions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request) {
        return this.listConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListConfigurationsResult> listConfigurationsAsync(ListConfigurationsRequest request, final AsyncHandler<ListConfigurationsRequest, ListConfigurationsResult> asyncHandler) {
        final ListConfigurationsRequest finalRequest = (ListConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListConfigurationsResult>(){

            @Override
            public ListConfigurationsResult call() throws Exception {
                ListConfigurationsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeListConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request) {
        return this.listTagsAsync(request, null);
    }

    @Override
    public Future<ListTagsResult> listTagsAsync(ListTagsRequest request, final AsyncHandler<ListTagsRequest, ListTagsResult> asyncHandler) {
        final ListTagsRequest finalRequest = (ListTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsResult>(){

            @Override
            public ListTagsResult call() throws Exception {
                ListTagsResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeListTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        final ListUsersRequest finalRequest = (ListUsersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeListUsers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request) {
        return this.rebootBrokerAsync(request, null);
    }

    @Override
    public Future<RebootBrokerResult> rebootBrokerAsync(RebootBrokerRequest request, final AsyncHandler<RebootBrokerRequest, RebootBrokerResult> asyncHandler) {
        final RebootBrokerRequest finalRequest = (RebootBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootBrokerResult>(){

            @Override
            public RebootBrokerResult call() throws Exception {
                RebootBrokerResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeRebootBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateBrokerResult> updateBrokerAsync(UpdateBrokerRequest request) {
        return this.updateBrokerAsync(request, null);
    }

    @Override
    public Future<UpdateBrokerResult> updateBrokerAsync(UpdateBrokerRequest request, final AsyncHandler<UpdateBrokerRequest, UpdateBrokerResult> asyncHandler) {
        final UpdateBrokerRequest finalRequest = (UpdateBrokerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateBrokerResult>(){

            @Override
            public UpdateBrokerResult call() throws Exception {
                UpdateBrokerResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeUpdateBroker(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request) {
        return this.updateConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateConfigurationResult> updateConfigurationAsync(UpdateConfigurationRequest request, final AsyncHandler<UpdateConfigurationRequest, UpdateConfigurationResult> asyncHandler) {
        final UpdateConfigurationRequest finalRequest = (UpdateConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConfigurationResult>(){

            @Override
            public UpdateConfigurationResult call() throws Exception {
                UpdateConfigurationResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeUpdateConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {
        return this.updateUserAsync(request, null);
    }

    @Override
    public Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request, final AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {
        final UpdateUserRequest finalRequest = (UpdateUserRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserResult>(){

            @Override
            public UpdateUserResult call() throws Exception {
                UpdateUserResult result = null;
                try {
                    result = AmazonMQAsyncClient.this.executeUpdateUser(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

