/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mobile;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mobile.AWSMobileAsync;
import com.amazonaws.services.mobile.AWSMobileAsyncClientBuilder;
import com.amazonaws.services.mobile.AWSMobileClient;
import com.amazonaws.services.mobile.model.CreateProjectRequest;
import com.amazonaws.services.mobile.model.CreateProjectResult;
import com.amazonaws.services.mobile.model.DeleteProjectRequest;
import com.amazonaws.services.mobile.model.DeleteProjectResult;
import com.amazonaws.services.mobile.model.DescribeBundleRequest;
import com.amazonaws.services.mobile.model.DescribeBundleResult;
import com.amazonaws.services.mobile.model.DescribeProjectRequest;
import com.amazonaws.services.mobile.model.DescribeProjectResult;
import com.amazonaws.services.mobile.model.ExportBundleRequest;
import com.amazonaws.services.mobile.model.ExportBundleResult;
import com.amazonaws.services.mobile.model.ExportProjectRequest;
import com.amazonaws.services.mobile.model.ExportProjectResult;
import com.amazonaws.services.mobile.model.ListBundlesRequest;
import com.amazonaws.services.mobile.model.ListBundlesResult;
import com.amazonaws.services.mobile.model.ListProjectsRequest;
import com.amazonaws.services.mobile.model.ListProjectsResult;
import com.amazonaws.services.mobile.model.UpdateProjectRequest;
import com.amazonaws.services.mobile.model.UpdateProjectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMobileAsyncClient
extends AWSMobileClient
implements AWSMobileAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMobileAsyncClientBuilder asyncBuilder() {
        return AWSMobileAsyncClientBuilder.standard();
    }

    AWSMobileAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectAsync(request, null);
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        final CreateProjectRequest finalRequest = (CreateProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeCreateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectAsync(request, null);
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request, final AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {
        final DeleteProjectRequest finalRequest = (DeleteProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProjectResult>(){

            @Override
            public DeleteProjectResult call() throws Exception {
                DeleteProjectResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeDeleteProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBundleResult> describeBundleAsync(DescribeBundleRequest request) {
        return this.describeBundleAsync(request, null);
    }

    @Override
    public Future<DescribeBundleResult> describeBundleAsync(DescribeBundleRequest request, final AsyncHandler<DescribeBundleRequest, DescribeBundleResult> asyncHandler) {
        final DescribeBundleRequest finalRequest = (DescribeBundleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBundleResult>(){

            @Override
            public DescribeBundleResult call() throws Exception {
                DescribeBundleResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeDescribeBundle(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request) {
        return this.describeProjectAsync(request, null);
    }

    @Override
    public Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request, final AsyncHandler<DescribeProjectRequest, DescribeProjectResult> asyncHandler) {
        final DescribeProjectRequest finalRequest = (DescribeProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProjectResult>(){

            @Override
            public DescribeProjectResult call() throws Exception {
                DescribeProjectResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeDescribeProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportBundleResult> exportBundleAsync(ExportBundleRequest request) {
        return this.exportBundleAsync(request, null);
    }

    @Override
    public Future<ExportBundleResult> exportBundleAsync(ExportBundleRequest request, final AsyncHandler<ExportBundleRequest, ExportBundleResult> asyncHandler) {
        final ExportBundleRequest finalRequest = (ExportBundleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportBundleResult>(){

            @Override
            public ExportBundleResult call() throws Exception {
                ExportBundleResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeExportBundle(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExportProjectResult> exportProjectAsync(ExportProjectRequest request) {
        return this.exportProjectAsync(request, null);
    }

    @Override
    public Future<ExportProjectResult> exportProjectAsync(ExportProjectRequest request, final AsyncHandler<ExportProjectRequest, ExportProjectResult> asyncHandler) {
        final ExportProjectRequest finalRequest = (ExportProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExportProjectResult>(){

            @Override
            public ExportProjectResult call() throws Exception {
                ExportProjectResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeExportProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBundlesResult> listBundlesAsync(ListBundlesRequest request) {
        return this.listBundlesAsync(request, null);
    }

    @Override
    public Future<ListBundlesResult> listBundlesAsync(ListBundlesRequest request, final AsyncHandler<ListBundlesRequest, ListBundlesResult> asyncHandler) {
        final ListBundlesRequest finalRequest = (ListBundlesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBundlesResult>(){

            @Override
            public ListBundlesResult call() throws Exception {
                ListBundlesResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeListBundles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {
        return this.listProjectsAsync(request, null);
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        final ListProjectsRequest finalRequest = (ListProjectsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeListProjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectAsync(request, null);
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request, final AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {
        final UpdateProjectRequest finalRequest = (UpdateProjectRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProjectResult>(){

            @Override
            public UpdateProjectResult call() throws Exception {
                UpdateProjectResult result = null;
                try {
                    result = AWSMobileAsyncClient.this.executeUpdateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

