/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhub;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.migrationhub.AWSMigrationHub;
import com.amazonaws.services.migrationhub.AWSMigrationHubClientBuilder;
import com.amazonaws.services.migrationhub.model.AWSMigrationHubException;
import com.amazonaws.services.migrationhub.model.AssociateCreatedArtifactRequest;
import com.amazonaws.services.migrationhub.model.AssociateCreatedArtifactResult;
import com.amazonaws.services.migrationhub.model.AssociateDiscoveredResourceRequest;
import com.amazonaws.services.migrationhub.model.AssociateDiscoveredResourceResult;
import com.amazonaws.services.migrationhub.model.CreateProgressUpdateStreamRequest;
import com.amazonaws.services.migrationhub.model.CreateProgressUpdateStreamResult;
import com.amazonaws.services.migrationhub.model.DeleteProgressUpdateStreamRequest;
import com.amazonaws.services.migrationhub.model.DeleteProgressUpdateStreamResult;
import com.amazonaws.services.migrationhub.model.DescribeApplicationStateRequest;
import com.amazonaws.services.migrationhub.model.DescribeApplicationStateResult;
import com.amazonaws.services.migrationhub.model.DescribeMigrationTaskRequest;
import com.amazonaws.services.migrationhub.model.DescribeMigrationTaskResult;
import com.amazonaws.services.migrationhub.model.DisassociateCreatedArtifactRequest;
import com.amazonaws.services.migrationhub.model.DisassociateCreatedArtifactResult;
import com.amazonaws.services.migrationhub.model.DisassociateDiscoveredResourceRequest;
import com.amazonaws.services.migrationhub.model.DisassociateDiscoveredResourceResult;
import com.amazonaws.services.migrationhub.model.ImportMigrationTaskRequest;
import com.amazonaws.services.migrationhub.model.ImportMigrationTaskResult;
import com.amazonaws.services.migrationhub.model.ListCreatedArtifactsRequest;
import com.amazonaws.services.migrationhub.model.ListCreatedArtifactsResult;
import com.amazonaws.services.migrationhub.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.migrationhub.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.migrationhub.model.ListMigrationTasksRequest;
import com.amazonaws.services.migrationhub.model.ListMigrationTasksResult;
import com.amazonaws.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import com.amazonaws.services.migrationhub.model.ListProgressUpdateStreamsResult;
import com.amazonaws.services.migrationhub.model.NotifyApplicationStateRequest;
import com.amazonaws.services.migrationhub.model.NotifyApplicationStateResult;
import com.amazonaws.services.migrationhub.model.NotifyMigrationTaskStateRequest;
import com.amazonaws.services.migrationhub.model.NotifyMigrationTaskStateResult;
import com.amazonaws.services.migrationhub.model.PutResourceAttributesRequest;
import com.amazonaws.services.migrationhub.model.PutResourceAttributesResult;
import com.amazonaws.services.migrationhub.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateCreatedArtifactRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateCreatedArtifactResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateDiscoveredResourceRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.AssociateDiscoveredResourceResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.CreateProgressUpdateStreamRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.CreateProgressUpdateStreamResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DeleteProgressUpdateStreamRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DeleteProgressUpdateStreamResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeApplicationStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeApplicationStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeMigrationTaskRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DescribeMigrationTaskResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateCreatedArtifactRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateCreatedArtifactResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateDiscoveredResourceRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.DisassociateDiscoveredResourceResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.DryRunOperationExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.HomeRegionNotSetExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ImportMigrationTaskRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ImportMigrationTaskResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListCreatedArtifactsRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListCreatedArtifactsResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListDiscoveredResourcesRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListDiscoveredResourcesResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListMigrationTasksRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListMigrationTasksResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListProgressUpdateStreamsRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.ListProgressUpdateStreamsResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyApplicationStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyApplicationStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyMigrationTaskStateRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.NotifyMigrationTaskStateResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.PolicyErrorExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.PutResourceAttributesRequestProtocolMarshaller;
import com.amazonaws.services.migrationhub.model.transform.PutResourceAttributesResultJsonUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.migrationhub.model.transform.UnauthorizedOperationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMigrationHubClient
extends AmazonWebServiceClient
implements AWSMigrationHub {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMigrationHub.class);
    private static final String DEFAULT_SIGNING_NAME = "mgh";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedOperation").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedOperationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInputException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidInputExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyErrorException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PolicyErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("HomeRegionNotSetException").withExceptionUnmarshaller((JsonErrorUnmarshaller)HomeRegionNotSetExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DryRunOperation").withExceptionUnmarshaller((JsonErrorUnmarshaller)DryRunOperationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMigrationHubException.class));

    public static AWSMigrationHubClientBuilder builder() {
        return AWSMigrationHubClientBuilder.standard();
    }

    AWSMigrationHubClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMigrationHubClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mgh.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/migrationhub/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/migrationhub/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AssociateCreatedArtifactResult associateCreatedArtifact(AssociateCreatedArtifactRequest request) {
        request = (AssociateCreatedArtifactRequest)this.beforeClientExecution(request);
        return this.executeAssociateCreatedArtifact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateCreatedArtifactResult executeAssociateCreatedArtifact(AssociateCreatedArtifactRequest associateCreatedArtifactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateCreatedArtifactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateCreatedArtifactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateCreatedArtifactRequestProtocolMarshaller(protocolFactory).marshall((AssociateCreatedArtifactRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateCreatedArtifactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateCreatedArtifact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateCreatedArtifactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateCreatedArtifactResult associateCreatedArtifactResult = (AssociateCreatedArtifactResult)response.getAwsResponse();
            return associateCreatedArtifactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public AssociateDiscoveredResourceResult associateDiscoveredResource(AssociateDiscoveredResourceRequest request) {
        request = (AssociateDiscoveredResourceRequest)this.beforeClientExecution(request);
        return this.executeAssociateDiscoveredResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AssociateDiscoveredResourceResult executeAssociateDiscoveredResource(AssociateDiscoveredResourceRequest associateDiscoveredResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateDiscoveredResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateDiscoveredResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateDiscoveredResourceRequestProtocolMarshaller(protocolFactory).marshall((AssociateDiscoveredResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateDiscoveredResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AssociateDiscoveredResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateDiscoveredResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateDiscoveredResourceResult associateDiscoveredResourceResult = (AssociateDiscoveredResourceResult)response.getAwsResponse();
            return associateDiscoveredResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProgressUpdateStreamResult createProgressUpdateStream(CreateProgressUpdateStreamRequest request) {
        request = (CreateProgressUpdateStreamRequest)this.beforeClientExecution(request);
        return this.executeCreateProgressUpdateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProgressUpdateStreamResult executeCreateProgressUpdateStream(CreateProgressUpdateStreamRequest createProgressUpdateStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProgressUpdateStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProgressUpdateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProgressUpdateStreamRequestProtocolMarshaller(protocolFactory).marshall((CreateProgressUpdateStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProgressUpdateStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProgressUpdateStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProgressUpdateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProgressUpdateStreamResult createProgressUpdateStreamResult = (CreateProgressUpdateStreamResult)response.getAwsResponse();
            return createProgressUpdateStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProgressUpdateStreamResult deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest request) {
        request = (DeleteProgressUpdateStreamRequest)this.beforeClientExecution(request);
        return this.executeDeleteProgressUpdateStream(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProgressUpdateStreamResult executeDeleteProgressUpdateStream(DeleteProgressUpdateStreamRequest deleteProgressUpdateStreamRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProgressUpdateStreamRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProgressUpdateStreamRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProgressUpdateStreamRequestProtocolMarshaller(protocolFactory).marshall((DeleteProgressUpdateStreamRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProgressUpdateStreamRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProgressUpdateStream");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProgressUpdateStreamResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProgressUpdateStreamResult deleteProgressUpdateStreamResult = (DeleteProgressUpdateStreamResult)response.getAwsResponse();
            return deleteProgressUpdateStreamResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeApplicationStateResult describeApplicationState(DescribeApplicationStateRequest request) {
        request = (DescribeApplicationStateRequest)this.beforeClientExecution(request);
        return this.executeDescribeApplicationState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeApplicationStateResult executeDescribeApplicationState(DescribeApplicationStateRequest describeApplicationStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeApplicationStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeApplicationStateRequestProtocolMarshaller(protocolFactory).marshall((DescribeApplicationStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeApplicationStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeApplicationState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeApplicationStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeApplicationStateResult describeApplicationStateResult = (DescribeApplicationStateResult)response.getAwsResponse();
            return describeApplicationStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeMigrationTaskResult describeMigrationTask(DescribeMigrationTaskRequest request) {
        request = (DescribeMigrationTaskRequest)this.beforeClientExecution(request);
        return this.executeDescribeMigrationTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeMigrationTaskResult executeDescribeMigrationTask(DescribeMigrationTaskRequest describeMigrationTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeMigrationTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeMigrationTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeMigrationTaskRequestProtocolMarshaller(protocolFactory).marshall((DescribeMigrationTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeMigrationTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeMigrationTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeMigrationTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeMigrationTaskResult describeMigrationTaskResult = (DescribeMigrationTaskResult)response.getAwsResponse();
            return describeMigrationTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateCreatedArtifactResult disassociateCreatedArtifact(DisassociateCreatedArtifactRequest request) {
        request = (DisassociateCreatedArtifactRequest)this.beforeClientExecution(request);
        return this.executeDisassociateCreatedArtifact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateCreatedArtifactResult executeDisassociateCreatedArtifact(DisassociateCreatedArtifactRequest disassociateCreatedArtifactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateCreatedArtifactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateCreatedArtifactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateCreatedArtifactRequestProtocolMarshaller(protocolFactory).marshall((DisassociateCreatedArtifactRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateCreatedArtifactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateCreatedArtifact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateCreatedArtifactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateCreatedArtifactResult disassociateCreatedArtifactResult = (DisassociateCreatedArtifactResult)response.getAwsResponse();
            return disassociateCreatedArtifactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateDiscoveredResourceResult disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest request) {
        request = (DisassociateDiscoveredResourceRequest)this.beforeClientExecution(request);
        return this.executeDisassociateDiscoveredResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateDiscoveredResourceResult executeDisassociateDiscoveredResource(DisassociateDiscoveredResourceRequest disassociateDiscoveredResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateDiscoveredResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateDiscoveredResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateDiscoveredResourceRequestProtocolMarshaller(protocolFactory).marshall((DisassociateDiscoveredResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateDiscoveredResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateDiscoveredResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateDiscoveredResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateDiscoveredResourceResult disassociateDiscoveredResourceResult = (DisassociateDiscoveredResourceResult)response.getAwsResponse();
            return disassociateDiscoveredResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ImportMigrationTaskResult importMigrationTask(ImportMigrationTaskRequest request) {
        request = (ImportMigrationTaskRequest)this.beforeClientExecution(request);
        return this.executeImportMigrationTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ImportMigrationTaskResult executeImportMigrationTask(ImportMigrationTaskRequest importMigrationTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(importMigrationTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ImportMigrationTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ImportMigrationTaskRequestProtocolMarshaller(protocolFactory).marshall((ImportMigrationTaskRequest)super.beforeMarshalling((AmazonWebServiceRequest)importMigrationTaskRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ImportMigrationTask");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ImportMigrationTaskResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ImportMigrationTaskResult importMigrationTaskResult = (ImportMigrationTaskResult)response.getAwsResponse();
            return importMigrationTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCreatedArtifactsResult listCreatedArtifacts(ListCreatedArtifactsRequest request) {
        request = (ListCreatedArtifactsRequest)this.beforeClientExecution(request);
        return this.executeListCreatedArtifacts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCreatedArtifactsResult executeListCreatedArtifacts(ListCreatedArtifactsRequest listCreatedArtifactsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCreatedArtifactsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCreatedArtifactsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCreatedArtifactsRequestProtocolMarshaller(protocolFactory).marshall((ListCreatedArtifactsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCreatedArtifactsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCreatedArtifacts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCreatedArtifactsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCreatedArtifactsResult listCreatedArtifactsResult = (ListCreatedArtifactsResult)response.getAwsResponse();
            return listCreatedArtifactsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDiscoveredResourcesResult listDiscoveredResources(ListDiscoveredResourcesRequest request) {
        request = (ListDiscoveredResourcesRequest)this.beforeClientExecution(request);
        return this.executeListDiscoveredResources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDiscoveredResourcesResult executeListDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDiscoveredResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDiscoveredResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDiscoveredResourcesRequestProtocolMarshaller(protocolFactory).marshall((ListDiscoveredResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDiscoveredResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDiscoveredResources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDiscoveredResourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDiscoveredResourcesResult listDiscoveredResourcesResult = (ListDiscoveredResourcesResult)response.getAwsResponse();
            return listDiscoveredResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMigrationTasksResult listMigrationTasks(ListMigrationTasksRequest request) {
        request = (ListMigrationTasksRequest)this.beforeClientExecution(request);
        return this.executeListMigrationTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMigrationTasksResult executeListMigrationTasks(ListMigrationTasksRequest listMigrationTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMigrationTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMigrationTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMigrationTasksRequestProtocolMarshaller(protocolFactory).marshall((ListMigrationTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMigrationTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMigrationTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMigrationTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMigrationTasksResult listMigrationTasksResult = (ListMigrationTasksResult)response.getAwsResponse();
            return listMigrationTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProgressUpdateStreamsResult listProgressUpdateStreams(ListProgressUpdateStreamsRequest request) {
        request = (ListProgressUpdateStreamsRequest)this.beforeClientExecution(request);
        return this.executeListProgressUpdateStreams(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProgressUpdateStreamsResult executeListProgressUpdateStreams(ListProgressUpdateStreamsRequest listProgressUpdateStreamsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProgressUpdateStreamsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProgressUpdateStreamsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProgressUpdateStreamsRequestProtocolMarshaller(protocolFactory).marshall((ListProgressUpdateStreamsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProgressUpdateStreamsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProgressUpdateStreams");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProgressUpdateStreamsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProgressUpdateStreamsResult listProgressUpdateStreamsResult = (ListProgressUpdateStreamsResult)response.getAwsResponse();
            return listProgressUpdateStreamsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyApplicationStateResult notifyApplicationState(NotifyApplicationStateRequest request) {
        request = (NotifyApplicationStateRequest)this.beforeClientExecution(request);
        return this.executeNotifyApplicationState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyApplicationStateResult executeNotifyApplicationState(NotifyApplicationStateRequest notifyApplicationStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyApplicationStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyApplicationStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyApplicationStateRequestProtocolMarshaller(protocolFactory).marshall((NotifyApplicationStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)notifyApplicationStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"NotifyApplicationState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyApplicationStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyApplicationStateResult notifyApplicationStateResult = (NotifyApplicationStateResult)response.getAwsResponse();
            return notifyApplicationStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public NotifyMigrationTaskStateResult notifyMigrationTaskState(NotifyMigrationTaskStateRequest request) {
        request = (NotifyMigrationTaskStateRequest)this.beforeClientExecution(request);
        return this.executeNotifyMigrationTaskState(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final NotifyMigrationTaskStateResult executeNotifyMigrationTaskState(NotifyMigrationTaskStateRequest notifyMigrationTaskStateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(notifyMigrationTaskStateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<NotifyMigrationTaskStateRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new NotifyMigrationTaskStateRequestProtocolMarshaller(protocolFactory).marshall((NotifyMigrationTaskStateRequest)super.beforeMarshalling((AmazonWebServiceRequest)notifyMigrationTaskStateRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"NotifyMigrationTaskState");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new NotifyMigrationTaskStateResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            NotifyMigrationTaskStateResult notifyMigrationTaskStateResult = (NotifyMigrationTaskStateResult)response.getAwsResponse();
            return notifyMigrationTaskStateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourceAttributesResult putResourceAttributes(PutResourceAttributesRequest request) {
        request = (PutResourceAttributesRequest)this.beforeClientExecution(request);
        return this.executePutResourceAttributes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourceAttributesResult executePutResourceAttributes(PutResourceAttributesRequest putResourceAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourceAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourceAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourceAttributesRequestProtocolMarshaller(protocolFactory).marshall((PutResourceAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)putResourceAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Migration Hub");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutResourceAttributes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourceAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourceAttributesResult putResourceAttributesResult = (PutResourceAttributesResult)response.getAwsResponse();
            return putResourceAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

