/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medicalimaging;

import javax.annotation.Generated;

import com.amazonaws.services.medicalimaging.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMedicalImaging}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMedicalImaging implements AWSMedicalImaging {

    protected AbstractAWSMedicalImaging() {
    }

    @Override
    public CopyImageSetResult copyImageSet(CopyImageSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDatastoreResult createDatastore(CreateDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDatastoreResult deleteDatastore(DeleteDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImageSetResult deleteImageSet(DeleteImageSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDICOMImportJobResult getDICOMImportJob(GetDICOMImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDatastoreResult getDatastore(GetDatastoreRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImageFrameResult getImageFrame(GetImageFrameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImageSetResult getImageSet(GetImageSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImageSetMetadataResult getImageSetMetadata(GetImageSetMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDICOMImportJobsResult listDICOMImportJobs(ListDICOMImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDatastoresResult listDatastores(ListDatastoresRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImageSetVersionsResult listImageSetVersions(ListImageSetVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchImageSetsResult searchImageSets(SearchImageSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartDICOMImportJobResult startDICOMImportJob(StartDICOMImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateImageSetMetadataResult updateImageSetMetadata(UpdateImageSetMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
