/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mediatailor.AWSMediaTailorAsync;
import com.amazonaws.services.mediatailor.AWSMediaTailorAsyncClientBuilder;
import com.amazonaws.services.mediatailor.AWSMediaTailorClient;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.DeletePlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.GetPlaybackConfigurationResult;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import com.amazonaws.services.mediatailor.model.ListPlaybackConfigurationsResult;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationRequest;
import com.amazonaws.services.mediatailor.model.PutPlaybackConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaTailorAsyncClient
extends AWSMediaTailorClient
implements AWSMediaTailorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaTailorAsyncClientBuilder asyncBuilder() {
        return AWSMediaTailorAsyncClientBuilder.standard();
    }

    AWSMediaTailorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeletePlaybackConfigurationResult> deletePlaybackConfigurationAsync(DeletePlaybackConfigurationRequest request) {
        return this.deletePlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<DeletePlaybackConfigurationResult> deletePlaybackConfigurationAsync(DeletePlaybackConfigurationRequest request, final AsyncHandler<DeletePlaybackConfigurationRequest, DeletePlaybackConfigurationResult> asyncHandler) {
        final DeletePlaybackConfigurationRequest finalRequest = (DeletePlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePlaybackConfigurationResult>(){

            @Override
            public DeletePlaybackConfigurationResult call() throws Exception {
                DeletePlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeDeletePlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPlaybackConfigurationResult> getPlaybackConfigurationAsync(GetPlaybackConfigurationRequest request) {
        return this.getPlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<GetPlaybackConfigurationResult> getPlaybackConfigurationAsync(GetPlaybackConfigurationRequest request, final AsyncHandler<GetPlaybackConfigurationRequest, GetPlaybackConfigurationResult> asyncHandler) {
        final GetPlaybackConfigurationRequest finalRequest = (GetPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPlaybackConfigurationResult>(){

            @Override
            public GetPlaybackConfigurationResult call() throws Exception {
                GetPlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeGetPlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPlaybackConfigurationsResult> listPlaybackConfigurationsAsync(ListPlaybackConfigurationsRequest request) {
        return this.listPlaybackConfigurationsAsync(request, null);
    }

    @Override
    public Future<ListPlaybackConfigurationsResult> listPlaybackConfigurationsAsync(ListPlaybackConfigurationsRequest request, final AsyncHandler<ListPlaybackConfigurationsRequest, ListPlaybackConfigurationsResult> asyncHandler) {
        final ListPlaybackConfigurationsRequest finalRequest = (ListPlaybackConfigurationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPlaybackConfigurationsResult>(){

            @Override
            public ListPlaybackConfigurationsResult call() throws Exception {
                ListPlaybackConfigurationsResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executeListPlaybackConfigurations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutPlaybackConfigurationResult> putPlaybackConfigurationAsync(PutPlaybackConfigurationRequest request) {
        return this.putPlaybackConfigurationAsync(request, null);
    }

    @Override
    public Future<PutPlaybackConfigurationResult> putPlaybackConfigurationAsync(PutPlaybackConfigurationRequest request, final AsyncHandler<PutPlaybackConfigurationRequest, PutPlaybackConfigurationResult> asyncHandler) {
        final PutPlaybackConfigurationRequest finalRequest = (PutPlaybackConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutPlaybackConfigurationResult>(){

            @Override
            public PutPlaybackConfigurationResult call() throws Exception {
                PutPlaybackConfigurationResult result = null;
                try {
                    result = AWSMediaTailorAsyncClient.this.executePutPlaybackConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

