/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackage;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediapackage.AWSMediaPackage;
import com.amazonaws.services.mediapackage.AWSMediaPackageClientBuilder;
import com.amazonaws.services.mediapackage.model.AWSMediaPackageException;
import com.amazonaws.services.mediapackage.model.CreateChannelRequest;
import com.amazonaws.services.mediapackage.model.CreateChannelResult;
import com.amazonaws.services.mediapackage.model.CreateOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.CreateOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.DeleteChannelRequest;
import com.amazonaws.services.mediapackage.model.DeleteChannelResult;
import com.amazonaws.services.mediapackage.model.DeleteOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.DeleteOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.DescribeChannelRequest;
import com.amazonaws.services.mediapackage.model.DescribeChannelResult;
import com.amazonaws.services.mediapackage.model.DescribeOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.DescribeOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.ForbiddenException;
import com.amazonaws.services.mediapackage.model.InternalServerErrorException;
import com.amazonaws.services.mediapackage.model.ListChannelsRequest;
import com.amazonaws.services.mediapackage.model.ListChannelsResult;
import com.amazonaws.services.mediapackage.model.ListOriginEndpointsRequest;
import com.amazonaws.services.mediapackage.model.ListOriginEndpointsResult;
import com.amazonaws.services.mediapackage.model.NotFoundException;
import com.amazonaws.services.mediapackage.model.RotateChannelCredentialsRequest;
import com.amazonaws.services.mediapackage.model.RotateChannelCredentialsResult;
import com.amazonaws.services.mediapackage.model.ServiceUnavailableException;
import com.amazonaws.services.mediapackage.model.TooManyRequestsException;
import com.amazonaws.services.mediapackage.model.UnprocessableEntityException;
import com.amazonaws.services.mediapackage.model.UpdateChannelRequest;
import com.amazonaws.services.mediapackage.model.UpdateChannelResult;
import com.amazonaws.services.mediapackage.model.UpdateOriginEndpointRequest;
import com.amazonaws.services.mediapackage.model.UpdateOriginEndpointResult;
import com.amazonaws.services.mediapackage.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.CreateOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.CreateOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.DeleteOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.DeleteOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.DescribeChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.DescribeChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.DescribeOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.DescribeOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.ListOriginEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.ListOriginEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.RotateChannelCredentialsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.RotateChannelCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackage.model.transform.UpdateOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackage.model.transform.UpdateOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaPackageClient
extends AmazonWebServiceClient
implements AWSMediaPackage {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaPackage.class);
    private static final String DEFAULT_SIGNING_NAME = "mediapackage";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withModeledClass(UnprocessableEntityException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withModeledClass(ServiceUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)).withBaseServiceExceptionClass(AWSMediaPackageException.class));

    public static AWSMediaPackageClientBuilder builder() {
        return AWSMediaPackageClientBuilder.standard();
    }

    AWSMediaPackageClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediapackage.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediapackage/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediapackage/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateOriginEndpointResult createOriginEndpoint(CreateOriginEndpointRequest request) {
        request = (CreateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeCreateOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateOriginEndpointResult executeCreateOriginEndpoint(CreateOriginEndpointRequest createOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((CreateOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateOriginEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateOriginEndpointResult createOriginEndpointResult = (CreateOriginEndpointResult)response.getAwsResponse();
            return createOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteOriginEndpointResult deleteOriginEndpoint(DeleteOriginEndpointRequest request) {
        request = (DeleteOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeDeleteOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteOriginEndpointResult executeDeleteOriginEndpoint(DeleteOriginEndpointRequest deleteOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((DeleteOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteOriginEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteOriginEndpointResult deleteOriginEndpointResult = (DeleteOriginEndpointResult)response.getAwsResponse();
            return deleteOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeChannelResult describeChannel(DescribeChannelRequest request) {
        request = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executeDescribeChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeChannelResult executeDescribeChannel(DescribeChannelRequest describeChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeChannelRequestProtocolMarshaller(protocolFactory).marshall((DescribeChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeChannelResult describeChannelResult = (DescribeChannelResult)response.getAwsResponse();
            return describeChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeOriginEndpointResult describeOriginEndpoint(DescribeOriginEndpointRequest request) {
        request = (DescribeOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeDescribeOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeOriginEndpointResult executeDescribeOriginEndpoint(DescribeOriginEndpointRequest describeOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((DescribeOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeOriginEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeOriginEndpointResult describeOriginEndpointResult = (DescribeOriginEndpointResult)response.getAwsResponse();
            return describeOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOriginEndpointsResult listOriginEndpoints(ListOriginEndpointsRequest request) {
        request = (ListOriginEndpointsRequest)this.beforeClientExecution(request);
        return this.executeListOriginEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOriginEndpointsResult executeListOriginEndpoints(ListOriginEndpointsRequest listOriginEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOriginEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOriginEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOriginEndpointsRequestProtocolMarshaller(protocolFactory).marshall((ListOriginEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOriginEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOriginEndpoints");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOriginEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOriginEndpointsResult listOriginEndpointsResult = (ListOriginEndpointsResult)response.getAwsResponse();
            return listOriginEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RotateChannelCredentialsResult rotateChannelCredentials(RotateChannelCredentialsRequest request) {
        request = (RotateChannelCredentialsRequest)this.beforeClientExecution(request);
        return this.executeRotateChannelCredentials(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RotateChannelCredentialsResult executeRotateChannelCredentials(RotateChannelCredentialsRequest rotateChannelCredentialsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rotateChannelCredentialsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RotateChannelCredentialsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RotateChannelCredentialsRequestProtocolMarshaller(protocolFactory).marshall((RotateChannelCredentialsRequest)super.beforeMarshalling((AmazonWebServiceRequest)rotateChannelCredentialsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RotateChannelCredentials");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RotateChannelCredentialsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RotateChannelCredentialsResult rotateChannelCredentialsResult = (RotateChannelCredentialsResult)response.getAwsResponse();
            return rotateChannelCredentialsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateOriginEndpointResult updateOriginEndpoint(UpdateOriginEndpointRequest request) {
        request = (UpdateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeUpdateOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateOriginEndpointResult executeUpdateOriginEndpoint(UpdateOriginEndpointRequest updateOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((UpdateOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackage");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateOriginEndpoint");
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateOriginEndpointResult updateOriginEndpointResult = (UpdateOriginEndpointResult)response.getAwsResponse();
            return updateOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

