/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.VideoSelector;

@SdkInternalApi
public class VideoSelectorMarshaller {
    private static final MarshallingInfo<String> COLORSPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpace").build();
    private static final MarshallingInfo<StructuredPojo> COLORSPACESETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceSettings").build();
    private static final MarshallingInfo<String> COLORSPACEUSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpaceUsage").build();
    private static final MarshallingInfo<StructuredPojo> SELECTORSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectorSettings").build();
    private static final VideoSelectorMarshaller instance = new VideoSelectorMarshaller();

    public static VideoSelectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(VideoSelector videoSelector, ProtocolMarshaller protocolMarshaller) {
        if (videoSelector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)videoSelector.getColorSpace(), COLORSPACE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.getColorSpaceSettings(), COLORSPACESETTINGS_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.getColorSpaceUsage(), COLORSPACEUSAGE_BINDING);
            protocolMarshaller.marshall((Object)videoSelector.getSelectorSettings(), SELECTORSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

