/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.medialive.AWSMediaLiveAsync;
import com.amazonaws.services.medialive.AWSMediaLiveAsyncClientBuilder;
import com.amazonaws.services.medialive.AWSMediaLiveClient;
import com.amazonaws.services.medialive.model.AcceptInputDeviceTransferRequest;
import com.amazonaws.services.medialive.model.AcceptInputDeviceTransferResult;
import com.amazonaws.services.medialive.model.BatchDeleteRequest;
import com.amazonaws.services.medialive.model.BatchDeleteResult;
import com.amazonaws.services.medialive.model.BatchStartRequest;
import com.amazonaws.services.medialive.model.BatchStartResult;
import com.amazonaws.services.medialive.model.BatchStopRequest;
import com.amazonaws.services.medialive.model.BatchStopResult;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleRequest;
import com.amazonaws.services.medialive.model.BatchUpdateScheduleResult;
import com.amazonaws.services.medialive.model.CancelInputDeviceTransferRequest;
import com.amazonaws.services.medialive.model.CancelInputDeviceTransferResult;
import com.amazonaws.services.medialive.model.ClaimDeviceRequest;
import com.amazonaws.services.medialive.model.ClaimDeviceResult;
import com.amazonaws.services.medialive.model.CreateChannelRequest;
import com.amazonaws.services.medialive.model.CreateChannelResult;
import com.amazonaws.services.medialive.model.CreateInputRequest;
import com.amazonaws.services.medialive.model.CreateInputResult;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.CreateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.CreateMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.CreateMultiplexProgramResult;
import com.amazonaws.services.medialive.model.CreateMultiplexRequest;
import com.amazonaws.services.medialive.model.CreateMultiplexResult;
import com.amazonaws.services.medialive.model.CreatePartnerInputRequest;
import com.amazonaws.services.medialive.model.CreatePartnerInputResult;
import com.amazonaws.services.medialive.model.CreateTagsRequest;
import com.amazonaws.services.medialive.model.CreateTagsResult;
import com.amazonaws.services.medialive.model.DeleteChannelRequest;
import com.amazonaws.services.medialive.model.DeleteChannelResult;
import com.amazonaws.services.medialive.model.DeleteInputRequest;
import com.amazonaws.services.medialive.model.DeleteInputResult;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DeleteInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DeleteMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.DeleteMultiplexProgramResult;
import com.amazonaws.services.medialive.model.DeleteMultiplexRequest;
import com.amazonaws.services.medialive.model.DeleteMultiplexResult;
import com.amazonaws.services.medialive.model.DeleteReservationRequest;
import com.amazonaws.services.medialive.model.DeleteReservationResult;
import com.amazonaws.services.medialive.model.DeleteScheduleRequest;
import com.amazonaws.services.medialive.model.DeleteScheduleResult;
import com.amazonaws.services.medialive.model.DeleteTagsRequest;
import com.amazonaws.services.medialive.model.DeleteTagsResult;
import com.amazonaws.services.medialive.model.DescribeAccountConfigurationRequest;
import com.amazonaws.services.medialive.model.DescribeAccountConfigurationResult;
import com.amazonaws.services.medialive.model.DescribeChannelRequest;
import com.amazonaws.services.medialive.model.DescribeChannelResult;
import com.amazonaws.services.medialive.model.DescribeInputDeviceRequest;
import com.amazonaws.services.medialive.model.DescribeInputDeviceResult;
import com.amazonaws.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import com.amazonaws.services.medialive.model.DescribeInputDeviceThumbnailResult;
import com.amazonaws.services.medialive.model.DescribeInputRequest;
import com.amazonaws.services.medialive.model.DescribeInputResult;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.DescribeInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.DescribeMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.DescribeMultiplexProgramResult;
import com.amazonaws.services.medialive.model.DescribeMultiplexRequest;
import com.amazonaws.services.medialive.model.DescribeMultiplexResult;
import com.amazonaws.services.medialive.model.DescribeOfferingRequest;
import com.amazonaws.services.medialive.model.DescribeOfferingResult;
import com.amazonaws.services.medialive.model.DescribeReservationRequest;
import com.amazonaws.services.medialive.model.DescribeReservationResult;
import com.amazonaws.services.medialive.model.DescribeScheduleRequest;
import com.amazonaws.services.medialive.model.DescribeScheduleResult;
import com.amazonaws.services.medialive.model.DescribeThumbnailsRequest;
import com.amazonaws.services.medialive.model.DescribeThumbnailsResult;
import com.amazonaws.services.medialive.model.ListChannelsRequest;
import com.amazonaws.services.medialive.model.ListChannelsResult;
import com.amazonaws.services.medialive.model.ListInputDeviceTransfersRequest;
import com.amazonaws.services.medialive.model.ListInputDeviceTransfersResult;
import com.amazonaws.services.medialive.model.ListInputDevicesRequest;
import com.amazonaws.services.medialive.model.ListInputDevicesResult;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsRequest;
import com.amazonaws.services.medialive.model.ListInputSecurityGroupsResult;
import com.amazonaws.services.medialive.model.ListInputsRequest;
import com.amazonaws.services.medialive.model.ListInputsResult;
import com.amazonaws.services.medialive.model.ListMultiplexProgramsRequest;
import com.amazonaws.services.medialive.model.ListMultiplexProgramsResult;
import com.amazonaws.services.medialive.model.ListMultiplexesRequest;
import com.amazonaws.services.medialive.model.ListMultiplexesResult;
import com.amazonaws.services.medialive.model.ListOfferingsRequest;
import com.amazonaws.services.medialive.model.ListOfferingsResult;
import com.amazonaws.services.medialive.model.ListReservationsRequest;
import com.amazonaws.services.medialive.model.ListReservationsResult;
import com.amazonaws.services.medialive.model.ListTagsForResourceRequest;
import com.amazonaws.services.medialive.model.ListTagsForResourceResult;
import com.amazonaws.services.medialive.model.PurchaseOfferingRequest;
import com.amazonaws.services.medialive.model.PurchaseOfferingResult;
import com.amazonaws.services.medialive.model.RebootInputDeviceRequest;
import com.amazonaws.services.medialive.model.RebootInputDeviceResult;
import com.amazonaws.services.medialive.model.RejectInputDeviceTransferRequest;
import com.amazonaws.services.medialive.model.RejectInputDeviceTransferResult;
import com.amazonaws.services.medialive.model.StartChannelRequest;
import com.amazonaws.services.medialive.model.StartChannelResult;
import com.amazonaws.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import com.amazonaws.services.medialive.model.StartInputDeviceMaintenanceWindowResult;
import com.amazonaws.services.medialive.model.StartMultiplexRequest;
import com.amazonaws.services.medialive.model.StartMultiplexResult;
import com.amazonaws.services.medialive.model.StopChannelRequest;
import com.amazonaws.services.medialive.model.StopChannelResult;
import com.amazonaws.services.medialive.model.StopMultiplexRequest;
import com.amazonaws.services.medialive.model.StopMultiplexResult;
import com.amazonaws.services.medialive.model.TransferInputDeviceRequest;
import com.amazonaws.services.medialive.model.TransferInputDeviceResult;
import com.amazonaws.services.medialive.model.UpdateAccountConfigurationRequest;
import com.amazonaws.services.medialive.model.UpdateAccountConfigurationResult;
import com.amazonaws.services.medialive.model.UpdateChannelClassRequest;
import com.amazonaws.services.medialive.model.UpdateChannelClassResult;
import com.amazonaws.services.medialive.model.UpdateChannelRequest;
import com.amazonaws.services.medialive.model.UpdateChannelResult;
import com.amazonaws.services.medialive.model.UpdateInputDeviceRequest;
import com.amazonaws.services.medialive.model.UpdateInputDeviceResult;
import com.amazonaws.services.medialive.model.UpdateInputRequest;
import com.amazonaws.services.medialive.model.UpdateInputResult;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupRequest;
import com.amazonaws.services.medialive.model.UpdateInputSecurityGroupResult;
import com.amazonaws.services.medialive.model.UpdateMultiplexProgramRequest;
import com.amazonaws.services.medialive.model.UpdateMultiplexProgramResult;
import com.amazonaws.services.medialive.model.UpdateMultiplexRequest;
import com.amazonaws.services.medialive.model.UpdateMultiplexResult;
import com.amazonaws.services.medialive.model.UpdateReservationRequest;
import com.amazonaws.services.medialive.model.UpdateReservationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMediaLiveAsyncClient
extends AWSMediaLiveClient
implements AWSMediaLiveAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMediaLiveAsyncClientBuilder asyncBuilder() {
        return AWSMediaLiveAsyncClientBuilder.standard();
    }

    AWSMediaLiveAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMediaLiveAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptInputDeviceTransferResult> acceptInputDeviceTransferAsync(AcceptInputDeviceTransferRequest request) {
        return this.acceptInputDeviceTransferAsync(request, null);
    }

    @Override
    public Future<AcceptInputDeviceTransferResult> acceptInputDeviceTransferAsync(AcceptInputDeviceTransferRequest request, final AsyncHandler<AcceptInputDeviceTransferRequest, AcceptInputDeviceTransferResult> asyncHandler) {
        final AcceptInputDeviceTransferRequest finalRequest = (AcceptInputDeviceTransferRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptInputDeviceTransferResult>(){

            @Override
            public AcceptInputDeviceTransferResult call() throws Exception {
                AcceptInputDeviceTransferResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeAcceptInputDeviceTransfer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteResult> batchDeleteAsync(BatchDeleteRequest request) {
        return this.batchDeleteAsync(request, null);
    }

    @Override
    public Future<BatchDeleteResult> batchDeleteAsync(BatchDeleteRequest request, final AsyncHandler<BatchDeleteRequest, BatchDeleteResult> asyncHandler) {
        final BatchDeleteRequest finalRequest = (BatchDeleteRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchDeleteResult>(){

            @Override
            public BatchDeleteResult call() throws Exception {
                BatchDeleteResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeBatchDelete(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchStartResult> batchStartAsync(BatchStartRequest request) {
        return this.batchStartAsync(request, null);
    }

    @Override
    public Future<BatchStartResult> batchStartAsync(BatchStartRequest request, final AsyncHandler<BatchStartRequest, BatchStartResult> asyncHandler) {
        final BatchStartRequest finalRequest = (BatchStartRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchStartResult>(){

            @Override
            public BatchStartResult call() throws Exception {
                BatchStartResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeBatchStart(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchStopResult> batchStopAsync(BatchStopRequest request) {
        return this.batchStopAsync(request, null);
    }

    @Override
    public Future<BatchStopResult> batchStopAsync(BatchStopRequest request, final AsyncHandler<BatchStopRequest, BatchStopResult> asyncHandler) {
        final BatchStopRequest finalRequest = (BatchStopRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchStopResult>(){

            @Override
            public BatchStopResult call() throws Exception {
                BatchStopResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeBatchStop(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchUpdateScheduleResult> batchUpdateScheduleAsync(BatchUpdateScheduleRequest request) {
        return this.batchUpdateScheduleAsync(request, null);
    }

    @Override
    public Future<BatchUpdateScheduleResult> batchUpdateScheduleAsync(BatchUpdateScheduleRequest request, final AsyncHandler<BatchUpdateScheduleRequest, BatchUpdateScheduleResult> asyncHandler) {
        final BatchUpdateScheduleRequest finalRequest = (BatchUpdateScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchUpdateScheduleResult>(){

            @Override
            public BatchUpdateScheduleResult call() throws Exception {
                BatchUpdateScheduleResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeBatchUpdateSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelInputDeviceTransferResult> cancelInputDeviceTransferAsync(CancelInputDeviceTransferRequest request) {
        return this.cancelInputDeviceTransferAsync(request, null);
    }

    @Override
    public Future<CancelInputDeviceTransferResult> cancelInputDeviceTransferAsync(CancelInputDeviceTransferRequest request, final AsyncHandler<CancelInputDeviceTransferRequest, CancelInputDeviceTransferResult> asyncHandler) {
        final CancelInputDeviceTransferRequest finalRequest = (CancelInputDeviceTransferRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelInputDeviceTransferResult>(){

            @Override
            public CancelInputDeviceTransferResult call() throws Exception {
                CancelInputDeviceTransferResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCancelInputDeviceTransfer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ClaimDeviceResult> claimDeviceAsync(ClaimDeviceRequest request) {
        return this.claimDeviceAsync(request, null);
    }

    @Override
    public Future<ClaimDeviceResult> claimDeviceAsync(ClaimDeviceRequest request, final AsyncHandler<ClaimDeviceRequest, ClaimDeviceResult> asyncHandler) {
        final ClaimDeviceRequest finalRequest = (ClaimDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ClaimDeviceResult>(){

            @Override
            public ClaimDeviceResult call() throws Exception {
                ClaimDeviceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeClaimDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request) {
        return this.createInputAsync(request, null);
    }

    @Override
    public Future<CreateInputResult> createInputAsync(CreateInputRequest request, final AsyncHandler<CreateInputRequest, CreateInputResult> asyncHandler) {
        final CreateInputRequest finalRequest = (CreateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInputResult>(){

            @Override
            public CreateInputResult call() throws Exception {
                CreateInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInputSecurityGroupResult> createInputSecurityGroupAsync(CreateInputSecurityGroupRequest request) {
        return this.createInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<CreateInputSecurityGroupResult> createInputSecurityGroupAsync(CreateInputSecurityGroupRequest request, final AsyncHandler<CreateInputSecurityGroupRequest, CreateInputSecurityGroupResult> asyncHandler) {
        final CreateInputSecurityGroupRequest finalRequest = (CreateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInputSecurityGroupResult>(){

            @Override
            public CreateInputSecurityGroupResult call() throws Exception {
                CreateInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMultiplexResult> createMultiplexAsync(CreateMultiplexRequest request) {
        return this.createMultiplexAsync(request, null);
    }

    @Override
    public Future<CreateMultiplexResult> createMultiplexAsync(CreateMultiplexRequest request, final AsyncHandler<CreateMultiplexRequest, CreateMultiplexResult> asyncHandler) {
        final CreateMultiplexRequest finalRequest = (CreateMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMultiplexResult>(){

            @Override
            public CreateMultiplexResult call() throws Exception {
                CreateMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMultiplexProgramResult> createMultiplexProgramAsync(CreateMultiplexProgramRequest request) {
        return this.createMultiplexProgramAsync(request, null);
    }

    @Override
    public Future<CreateMultiplexProgramResult> createMultiplexProgramAsync(CreateMultiplexProgramRequest request, final AsyncHandler<CreateMultiplexProgramRequest, CreateMultiplexProgramResult> asyncHandler) {
        final CreateMultiplexProgramRequest finalRequest = (CreateMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMultiplexProgramResult>(){

            @Override
            public CreateMultiplexProgramResult call() throws Exception {
                CreateMultiplexProgramResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateMultiplexProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePartnerInputResult> createPartnerInputAsync(CreatePartnerInputRequest request) {
        return this.createPartnerInputAsync(request, null);
    }

    @Override
    public Future<CreatePartnerInputResult> createPartnerInputAsync(CreatePartnerInputRequest request, final AsyncHandler<CreatePartnerInputRequest, CreatePartnerInputResult> asyncHandler) {
        final CreatePartnerInputRequest finalRequest = (CreatePartnerInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePartnerInputResult>(){

            @Override
            public CreatePartnerInputResult call() throws Exception {
                CreatePartnerInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreatePartnerInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request) {
        return this.createTagsAsync(request, null);
    }

    @Override
    public Future<CreateTagsResult> createTagsAsync(CreateTagsRequest request, final AsyncHandler<CreateTagsRequest, CreateTagsResult> asyncHandler) {
        final CreateTagsRequest finalRequest = (CreateTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTagsResult>(){

            @Override
            public CreateTagsResult call() throws Exception {
                CreateTagsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeCreateTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request) {
        return this.deleteInputAsync(request, null);
    }

    @Override
    public Future<DeleteInputResult> deleteInputAsync(DeleteInputRequest request, final AsyncHandler<DeleteInputRequest, DeleteInputResult> asyncHandler) {
        final DeleteInputRequest finalRequest = (DeleteInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInputResult>(){

            @Override
            public DeleteInputResult call() throws Exception {
                DeleteInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInputSecurityGroupResult> deleteInputSecurityGroupAsync(DeleteInputSecurityGroupRequest request) {
        return this.deleteInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteInputSecurityGroupResult> deleteInputSecurityGroupAsync(DeleteInputSecurityGroupRequest request, final AsyncHandler<DeleteInputSecurityGroupRequest, DeleteInputSecurityGroupResult> asyncHandler) {
        final DeleteInputSecurityGroupRequest finalRequest = (DeleteInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInputSecurityGroupResult>(){

            @Override
            public DeleteInputSecurityGroupResult call() throws Exception {
                DeleteInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMultiplexResult> deleteMultiplexAsync(DeleteMultiplexRequest request) {
        return this.deleteMultiplexAsync(request, null);
    }

    @Override
    public Future<DeleteMultiplexResult> deleteMultiplexAsync(DeleteMultiplexRequest request, final AsyncHandler<DeleteMultiplexRequest, DeleteMultiplexResult> asyncHandler) {
        final DeleteMultiplexRequest finalRequest = (DeleteMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMultiplexResult>(){

            @Override
            public DeleteMultiplexResult call() throws Exception {
                DeleteMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMultiplexProgramResult> deleteMultiplexProgramAsync(DeleteMultiplexProgramRequest request) {
        return this.deleteMultiplexProgramAsync(request, null);
    }

    @Override
    public Future<DeleteMultiplexProgramResult> deleteMultiplexProgramAsync(DeleteMultiplexProgramRequest request, final AsyncHandler<DeleteMultiplexProgramRequest, DeleteMultiplexProgramResult> asyncHandler) {
        final DeleteMultiplexProgramRequest finalRequest = (DeleteMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMultiplexProgramResult>(){

            @Override
            public DeleteMultiplexProgramResult call() throws Exception {
                DeleteMultiplexProgramResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteMultiplexProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteReservationResult> deleteReservationAsync(DeleteReservationRequest request) {
        return this.deleteReservationAsync(request, null);
    }

    @Override
    public Future<DeleteReservationResult> deleteReservationAsync(DeleteReservationRequest request, final AsyncHandler<DeleteReservationRequest, DeleteReservationResult> asyncHandler) {
        final DeleteReservationRequest finalRequest = (DeleteReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteReservationResult>(){

            @Override
            public DeleteReservationResult call() throws Exception {
                DeleteReservationResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteScheduleResult> deleteScheduleAsync(DeleteScheduleRequest request) {
        return this.deleteScheduleAsync(request, null);
    }

    @Override
    public Future<DeleteScheduleResult> deleteScheduleAsync(DeleteScheduleRequest request, final AsyncHandler<DeleteScheduleRequest, DeleteScheduleResult> asyncHandler) {
        final DeleteScheduleRequest finalRequest = (DeleteScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteScheduleResult>(){

            @Override
            public DeleteScheduleResult call() throws Exception {
                DeleteScheduleResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request) {
        return this.deleteTagsAsync(request, null);
    }

    @Override
    public Future<DeleteTagsResult> deleteTagsAsync(DeleteTagsRequest request, final AsyncHandler<DeleteTagsRequest, DeleteTagsResult> asyncHandler) {
        final DeleteTagsRequest finalRequest = (DeleteTagsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTagsResult>(){

            @Override
            public DeleteTagsResult call() throws Exception {
                DeleteTagsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDeleteTags(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountConfigurationResult> describeAccountConfigurationAsync(DescribeAccountConfigurationRequest request) {
        return this.describeAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeAccountConfigurationResult> describeAccountConfigurationAsync(DescribeAccountConfigurationRequest request, final AsyncHandler<DescribeAccountConfigurationRequest, DescribeAccountConfigurationResult> asyncHandler) {
        final DescribeAccountConfigurationRequest finalRequest = (DescribeAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccountConfigurationResult>(){

            @Override
            public DescribeAccountConfigurationResult call() throws Exception {
                DescribeAccountConfigurationResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request) {
        return this.describeChannelAsync(request, null);
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request, final AsyncHandler<DescribeChannelRequest, DescribeChannelResult> asyncHandler) {
        final DescribeChannelRequest finalRequest = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChannelResult>(){

            @Override
            public DescribeChannelResult call() throws Exception {
                DescribeChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request) {
        return this.describeInputAsync(request, null);
    }

    @Override
    public Future<DescribeInputResult> describeInputAsync(DescribeInputRequest request, final AsyncHandler<DescribeInputRequest, DescribeInputResult> asyncHandler) {
        final DescribeInputRequest finalRequest = (DescribeInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputResult>(){

            @Override
            public DescribeInputResult call() throws Exception {
                DescribeInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputDeviceResult> describeInputDeviceAsync(DescribeInputDeviceRequest request) {
        return this.describeInputDeviceAsync(request, null);
    }

    @Override
    public Future<DescribeInputDeviceResult> describeInputDeviceAsync(DescribeInputDeviceRequest request, final AsyncHandler<DescribeInputDeviceRequest, DescribeInputDeviceResult> asyncHandler) {
        final DescribeInputDeviceRequest finalRequest = (DescribeInputDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputDeviceResult>(){

            @Override
            public DescribeInputDeviceResult call() throws Exception {
                DescribeInputDeviceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInputDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputDeviceThumbnailResult> describeInputDeviceThumbnailAsync(DescribeInputDeviceThumbnailRequest request) {
        return this.describeInputDeviceThumbnailAsync(request, null);
    }

    @Override
    public Future<DescribeInputDeviceThumbnailResult> describeInputDeviceThumbnailAsync(DescribeInputDeviceThumbnailRequest request, final AsyncHandler<DescribeInputDeviceThumbnailRequest, DescribeInputDeviceThumbnailResult> asyncHandler) {
        final DescribeInputDeviceThumbnailRequest finalRequest = (DescribeInputDeviceThumbnailRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputDeviceThumbnailResult>(){

            @Override
            public DescribeInputDeviceThumbnailResult call() throws Exception {
                DescribeInputDeviceThumbnailResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInputDeviceThumbnail(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInputSecurityGroupResult> describeInputSecurityGroupAsync(DescribeInputSecurityGroupRequest request) {
        return this.describeInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DescribeInputSecurityGroupResult> describeInputSecurityGroupAsync(DescribeInputSecurityGroupRequest request, final AsyncHandler<DescribeInputSecurityGroupRequest, DescribeInputSecurityGroupResult> asyncHandler) {
        final DescribeInputSecurityGroupRequest finalRequest = (DescribeInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInputSecurityGroupResult>(){

            @Override
            public DescribeInputSecurityGroupResult call() throws Exception {
                DescribeInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMultiplexResult> describeMultiplexAsync(DescribeMultiplexRequest request) {
        return this.describeMultiplexAsync(request, null);
    }

    @Override
    public Future<DescribeMultiplexResult> describeMultiplexAsync(DescribeMultiplexRequest request, final AsyncHandler<DescribeMultiplexRequest, DescribeMultiplexResult> asyncHandler) {
        final DescribeMultiplexRequest finalRequest = (DescribeMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMultiplexResult>(){

            @Override
            public DescribeMultiplexResult call() throws Exception {
                DescribeMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMultiplexProgramResult> describeMultiplexProgramAsync(DescribeMultiplexProgramRequest request) {
        return this.describeMultiplexProgramAsync(request, null);
    }

    @Override
    public Future<DescribeMultiplexProgramResult> describeMultiplexProgramAsync(DescribeMultiplexProgramRequest request, final AsyncHandler<DescribeMultiplexProgramRequest, DescribeMultiplexProgramResult> asyncHandler) {
        final DescribeMultiplexProgramRequest finalRequest = (DescribeMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeMultiplexProgramResult>(){

            @Override
            public DescribeMultiplexProgramResult call() throws Exception {
                DescribeMultiplexProgramResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeMultiplexProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request) {
        return this.describeOfferingAsync(request, null);
    }

    @Override
    public Future<DescribeOfferingResult> describeOfferingAsync(DescribeOfferingRequest request, final AsyncHandler<DescribeOfferingRequest, DescribeOfferingResult> asyncHandler) {
        final DescribeOfferingRequest finalRequest = (DescribeOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOfferingResult>(){

            @Override
            public DescribeOfferingResult call() throws Exception {
                DescribeOfferingResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request) {
        return this.describeReservationAsync(request, null);
    }

    @Override
    public Future<DescribeReservationResult> describeReservationAsync(DescribeReservationRequest request, final AsyncHandler<DescribeReservationRequest, DescribeReservationResult> asyncHandler) {
        final DescribeReservationRequest finalRequest = (DescribeReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservationResult>(){

            @Override
            public DescribeReservationResult call() throws Exception {
                DescribeReservationResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeScheduleResult> describeScheduleAsync(DescribeScheduleRequest request) {
        return this.describeScheduleAsync(request, null);
    }

    @Override
    public Future<DescribeScheduleResult> describeScheduleAsync(DescribeScheduleRequest request, final AsyncHandler<DescribeScheduleRequest, DescribeScheduleResult> asyncHandler) {
        final DescribeScheduleRequest finalRequest = (DescribeScheduleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeScheduleResult>(){

            @Override
            public DescribeScheduleResult call() throws Exception {
                DescribeScheduleResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeSchedule(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeThumbnailsResult> describeThumbnailsAsync(DescribeThumbnailsRequest request) {
        return this.describeThumbnailsAsync(request, null);
    }

    @Override
    public Future<DescribeThumbnailsResult> describeThumbnailsAsync(DescribeThumbnailsRequest request, final AsyncHandler<DescribeThumbnailsRequest, DescribeThumbnailsResult> asyncHandler) {
        final DescribeThumbnailsRequest finalRequest = (DescribeThumbnailsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeThumbnailsResult>(){

            @Override
            public DescribeThumbnailsResult call() throws Exception {
                DescribeThumbnailsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeDescribeThumbnails(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputDeviceTransfersResult> listInputDeviceTransfersAsync(ListInputDeviceTransfersRequest request) {
        return this.listInputDeviceTransfersAsync(request, null);
    }

    @Override
    public Future<ListInputDeviceTransfersResult> listInputDeviceTransfersAsync(ListInputDeviceTransfersRequest request, final AsyncHandler<ListInputDeviceTransfersRequest, ListInputDeviceTransfersResult> asyncHandler) {
        final ListInputDeviceTransfersRequest finalRequest = (ListInputDeviceTransfersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputDeviceTransfersResult>(){

            @Override
            public ListInputDeviceTransfersResult call() throws Exception {
                ListInputDeviceTransfersResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputDeviceTransfers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputDevicesResult> listInputDevicesAsync(ListInputDevicesRequest request) {
        return this.listInputDevicesAsync(request, null);
    }

    @Override
    public Future<ListInputDevicesResult> listInputDevicesAsync(ListInputDevicesRequest request, final AsyncHandler<ListInputDevicesRequest, ListInputDevicesResult> asyncHandler) {
        final ListInputDevicesRequest finalRequest = (ListInputDevicesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputDevicesResult>(){

            @Override
            public ListInputDevicesResult call() throws Exception {
                ListInputDevicesResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputDevices(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputSecurityGroupsResult> listInputSecurityGroupsAsync(ListInputSecurityGroupsRequest request) {
        return this.listInputSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<ListInputSecurityGroupsResult> listInputSecurityGroupsAsync(ListInputSecurityGroupsRequest request, final AsyncHandler<ListInputSecurityGroupsRequest, ListInputSecurityGroupsResult> asyncHandler) {
        final ListInputSecurityGroupsRequest finalRequest = (ListInputSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputSecurityGroupsResult>(){

            @Override
            public ListInputSecurityGroupsResult call() throws Exception {
                ListInputSecurityGroupsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request) {
        return this.listInputsAsync(request, null);
    }

    @Override
    public Future<ListInputsResult> listInputsAsync(ListInputsRequest request, final AsyncHandler<ListInputsRequest, ListInputsResult> asyncHandler) {
        final ListInputsRequest finalRequest = (ListInputsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInputsResult>(){

            @Override
            public ListInputsResult call() throws Exception {
                ListInputsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListInputs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMultiplexProgramsResult> listMultiplexProgramsAsync(ListMultiplexProgramsRequest request) {
        return this.listMultiplexProgramsAsync(request, null);
    }

    @Override
    public Future<ListMultiplexProgramsResult> listMultiplexProgramsAsync(ListMultiplexProgramsRequest request, final AsyncHandler<ListMultiplexProgramsRequest, ListMultiplexProgramsResult> asyncHandler) {
        final ListMultiplexProgramsRequest finalRequest = (ListMultiplexProgramsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMultiplexProgramsResult>(){

            @Override
            public ListMultiplexProgramsResult call() throws Exception {
                ListMultiplexProgramsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListMultiplexPrograms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMultiplexesResult> listMultiplexesAsync(ListMultiplexesRequest request) {
        return this.listMultiplexesAsync(request, null);
    }

    @Override
    public Future<ListMultiplexesResult> listMultiplexesAsync(ListMultiplexesRequest request, final AsyncHandler<ListMultiplexesRequest, ListMultiplexesResult> asyncHandler) {
        final ListMultiplexesRequest finalRequest = (ListMultiplexesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMultiplexesResult>(){

            @Override
            public ListMultiplexesResult call() throws Exception {
                ListMultiplexesResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListMultiplexes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request) {
        return this.listOfferingsAsync(request, null);
    }

    @Override
    public Future<ListOfferingsResult> listOfferingsAsync(ListOfferingsRequest request, final AsyncHandler<ListOfferingsRequest, ListOfferingsResult> asyncHandler) {
        final ListOfferingsRequest finalRequest = (ListOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOfferingsResult>(){

            @Override
            public ListOfferingsResult call() throws Exception {
                ListOfferingsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request) {
        return this.listReservationsAsync(request, null);
    }

    @Override
    public Future<ListReservationsResult> listReservationsAsync(ListReservationsRequest request, final AsyncHandler<ListReservationsRequest, ListReservationsResult> asyncHandler) {
        final ListReservationsRequest finalRequest = (ListReservationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReservationsResult>(){

            @Override
            public ListReservationsResult call() throws Exception {
                ListReservationsResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListReservations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request) {
        return this.purchaseOfferingAsync(request, null);
    }

    @Override
    public Future<PurchaseOfferingResult> purchaseOfferingAsync(PurchaseOfferingRequest request, final AsyncHandler<PurchaseOfferingRequest, PurchaseOfferingResult> asyncHandler) {
        final PurchaseOfferingRequest finalRequest = (PurchaseOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PurchaseOfferingResult>(){

            @Override
            public PurchaseOfferingResult call() throws Exception {
                PurchaseOfferingResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executePurchaseOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RebootInputDeviceResult> rebootInputDeviceAsync(RebootInputDeviceRequest request) {
        return this.rebootInputDeviceAsync(request, null);
    }

    @Override
    public Future<RebootInputDeviceResult> rebootInputDeviceAsync(RebootInputDeviceRequest request, final AsyncHandler<RebootInputDeviceRequest, RebootInputDeviceResult> asyncHandler) {
        final RebootInputDeviceRequest finalRequest = (RebootInputDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RebootInputDeviceResult>(){

            @Override
            public RebootInputDeviceResult call() throws Exception {
                RebootInputDeviceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeRebootInputDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectInputDeviceTransferResult> rejectInputDeviceTransferAsync(RejectInputDeviceTransferRequest request) {
        return this.rejectInputDeviceTransferAsync(request, null);
    }

    @Override
    public Future<RejectInputDeviceTransferResult> rejectInputDeviceTransferAsync(RejectInputDeviceTransferRequest request, final AsyncHandler<RejectInputDeviceTransferRequest, RejectInputDeviceTransferResult> asyncHandler) {
        final RejectInputDeviceTransferRequest finalRequest = (RejectInputDeviceTransferRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectInputDeviceTransferResult>(){

            @Override
            public RejectInputDeviceTransferResult call() throws Exception {
                RejectInputDeviceTransferResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeRejectInputDeviceTransfer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request) {
        return this.startChannelAsync(request, null);
    }

    @Override
    public Future<StartChannelResult> startChannelAsync(StartChannelRequest request, final AsyncHandler<StartChannelRequest, StartChannelResult> asyncHandler) {
        final StartChannelRequest finalRequest = (StartChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartChannelResult>(){

            @Override
            public StartChannelResult call() throws Exception {
                StartChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStartChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartInputDeviceMaintenanceWindowResult> startInputDeviceMaintenanceWindowAsync(StartInputDeviceMaintenanceWindowRequest request) {
        return this.startInputDeviceMaintenanceWindowAsync(request, null);
    }

    @Override
    public Future<StartInputDeviceMaintenanceWindowResult> startInputDeviceMaintenanceWindowAsync(StartInputDeviceMaintenanceWindowRequest request, final AsyncHandler<StartInputDeviceMaintenanceWindowRequest, StartInputDeviceMaintenanceWindowResult> asyncHandler) {
        final StartInputDeviceMaintenanceWindowRequest finalRequest = (StartInputDeviceMaintenanceWindowRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartInputDeviceMaintenanceWindowResult>(){

            @Override
            public StartInputDeviceMaintenanceWindowResult call() throws Exception {
                StartInputDeviceMaintenanceWindowResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStartInputDeviceMaintenanceWindow(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMultiplexResult> startMultiplexAsync(StartMultiplexRequest request) {
        return this.startMultiplexAsync(request, null);
    }

    @Override
    public Future<StartMultiplexResult> startMultiplexAsync(StartMultiplexRequest request, final AsyncHandler<StartMultiplexRequest, StartMultiplexResult> asyncHandler) {
        final StartMultiplexRequest finalRequest = (StartMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMultiplexResult>(){

            @Override
            public StartMultiplexResult call() throws Exception {
                StartMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStartMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request) {
        return this.stopChannelAsync(request, null);
    }

    @Override
    public Future<StopChannelResult> stopChannelAsync(StopChannelRequest request, final AsyncHandler<StopChannelRequest, StopChannelResult> asyncHandler) {
        final StopChannelRequest finalRequest = (StopChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopChannelResult>(){

            @Override
            public StopChannelResult call() throws Exception {
                StopChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStopChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopMultiplexResult> stopMultiplexAsync(StopMultiplexRequest request) {
        return this.stopMultiplexAsync(request, null);
    }

    @Override
    public Future<StopMultiplexResult> stopMultiplexAsync(StopMultiplexRequest request, final AsyncHandler<StopMultiplexRequest, StopMultiplexResult> asyncHandler) {
        final StopMultiplexRequest finalRequest = (StopMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopMultiplexResult>(){

            @Override
            public StopMultiplexResult call() throws Exception {
                StopMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeStopMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TransferInputDeviceResult> transferInputDeviceAsync(TransferInputDeviceRequest request) {
        return this.transferInputDeviceAsync(request, null);
    }

    @Override
    public Future<TransferInputDeviceResult> transferInputDeviceAsync(TransferInputDeviceRequest request, final AsyncHandler<TransferInputDeviceRequest, TransferInputDeviceResult> asyncHandler) {
        final TransferInputDeviceRequest finalRequest = (TransferInputDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TransferInputDeviceResult>(){

            @Override
            public TransferInputDeviceResult call() throws Exception {
                TransferInputDeviceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeTransferInputDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAccountConfigurationResult> updateAccountConfigurationAsync(UpdateAccountConfigurationRequest request) {
        return this.updateAccountConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateAccountConfigurationResult> updateAccountConfigurationAsync(UpdateAccountConfigurationRequest request, final AsyncHandler<UpdateAccountConfigurationRequest, UpdateAccountConfigurationResult> asyncHandler) {
        final UpdateAccountConfigurationRequest finalRequest = (UpdateAccountConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAccountConfigurationResult>(){

            @Override
            public UpdateAccountConfigurationResult call() throws Exception {
                UpdateAccountConfigurationResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateAccountConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelClassResult> updateChannelClassAsync(UpdateChannelClassRequest request) {
        return this.updateChannelClassAsync(request, null);
    }

    @Override
    public Future<UpdateChannelClassResult> updateChannelClassAsync(UpdateChannelClassRequest request, final AsyncHandler<UpdateChannelClassRequest, UpdateChannelClassResult> asyncHandler) {
        final UpdateChannelClassRequest finalRequest = (UpdateChannelClassRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelClassResult>(){

            @Override
            public UpdateChannelClassResult call() throws Exception {
                UpdateChannelClassResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateChannelClass(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request) {
        return this.updateInputAsync(request, null);
    }

    @Override
    public Future<UpdateInputResult> updateInputAsync(UpdateInputRequest request, final AsyncHandler<UpdateInputRequest, UpdateInputResult> asyncHandler) {
        final UpdateInputRequest finalRequest = (UpdateInputRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputResult>(){

            @Override
            public UpdateInputResult call() throws Exception {
                UpdateInputResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateInput(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputDeviceResult> updateInputDeviceAsync(UpdateInputDeviceRequest request) {
        return this.updateInputDeviceAsync(request, null);
    }

    @Override
    public Future<UpdateInputDeviceResult> updateInputDeviceAsync(UpdateInputDeviceRequest request, final AsyncHandler<UpdateInputDeviceRequest, UpdateInputDeviceResult> asyncHandler) {
        final UpdateInputDeviceRequest finalRequest = (UpdateInputDeviceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputDeviceResult>(){

            @Override
            public UpdateInputDeviceResult call() throws Exception {
                UpdateInputDeviceResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateInputDevice(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInputSecurityGroupResult> updateInputSecurityGroupAsync(UpdateInputSecurityGroupRequest request) {
        return this.updateInputSecurityGroupAsync(request, null);
    }

    @Override
    public Future<UpdateInputSecurityGroupResult> updateInputSecurityGroupAsync(UpdateInputSecurityGroupRequest request, final AsyncHandler<UpdateInputSecurityGroupRequest, UpdateInputSecurityGroupResult> asyncHandler) {
        final UpdateInputSecurityGroupRequest finalRequest = (UpdateInputSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInputSecurityGroupResult>(){

            @Override
            public UpdateInputSecurityGroupResult call() throws Exception {
                UpdateInputSecurityGroupResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateInputSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMultiplexResult> updateMultiplexAsync(UpdateMultiplexRequest request) {
        return this.updateMultiplexAsync(request, null);
    }

    @Override
    public Future<UpdateMultiplexResult> updateMultiplexAsync(UpdateMultiplexRequest request, final AsyncHandler<UpdateMultiplexRequest, UpdateMultiplexResult> asyncHandler) {
        final UpdateMultiplexRequest finalRequest = (UpdateMultiplexRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMultiplexResult>(){

            @Override
            public UpdateMultiplexResult call() throws Exception {
                UpdateMultiplexResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateMultiplex(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMultiplexProgramResult> updateMultiplexProgramAsync(UpdateMultiplexProgramRequest request) {
        return this.updateMultiplexProgramAsync(request, null);
    }

    @Override
    public Future<UpdateMultiplexProgramResult> updateMultiplexProgramAsync(UpdateMultiplexProgramRequest request, final AsyncHandler<UpdateMultiplexProgramRequest, UpdateMultiplexProgramResult> asyncHandler) {
        final UpdateMultiplexProgramRequest finalRequest = (UpdateMultiplexProgramRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMultiplexProgramResult>(){

            @Override
            public UpdateMultiplexProgramResult call() throws Exception {
                UpdateMultiplexProgramResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateMultiplexProgram(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateReservationResult> updateReservationAsync(UpdateReservationRequest request) {
        return this.updateReservationAsync(request, null);
    }

    @Override
    public Future<UpdateReservationResult> updateReservationAsync(UpdateReservationRequest request, final AsyncHandler<UpdateReservationRequest, UpdateReservationResult> asyncHandler) {
        final UpdateReservationRequest finalRequest = (UpdateReservationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateReservationResult>(){

            @Override
            public UpdateReservationResult call() throws Exception {
                UpdateReservationResult result = null;
                try {
                    result = AWSMediaLiveAsyncClient.this.executeUpdateReservation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

