/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputDeviceIpScheme;
import com.amazonaws.services.medialive.model.transform.InputDeviceNetworkSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputDeviceNetworkSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> dnsAddresses;
    private String gateway;
    private String ipAddress;
    private String ipScheme;
    private String subnetMask;

    public List<String> getDnsAddresses() {
        return this.dnsAddresses;
    }

    public void setDnsAddresses(Collection<String> dnsAddresses) {
        if (dnsAddresses == null) {
            this.dnsAddresses = null;
            return;
        }
        this.dnsAddresses = new ArrayList<String>(dnsAddresses);
    }

    public InputDeviceNetworkSettings withDnsAddresses(String ... dnsAddresses) {
        if (this.dnsAddresses == null) {
            this.setDnsAddresses(new ArrayList<String>(dnsAddresses.length));
        }
        for (String ele : dnsAddresses) {
            this.dnsAddresses.add(ele);
        }
        return this;
    }

    public InputDeviceNetworkSettings withDnsAddresses(Collection<String> dnsAddresses) {
        this.setDnsAddresses(dnsAddresses);
        return this;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getGateway() {
        return this.gateway;
    }

    public InputDeviceNetworkSettings withGateway(String gateway) {
        this.setGateway(gateway);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public InputDeviceNetworkSettings withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setIpScheme(String ipScheme) {
        this.ipScheme = ipScheme;
    }

    public String getIpScheme() {
        return this.ipScheme;
    }

    public InputDeviceNetworkSettings withIpScheme(String ipScheme) {
        this.setIpScheme(ipScheme);
        return this;
    }

    public InputDeviceNetworkSettings withIpScheme(InputDeviceIpScheme ipScheme) {
        this.ipScheme = ipScheme.toString();
        return this;
    }

    public void setSubnetMask(String subnetMask) {
        this.subnetMask = subnetMask;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public InputDeviceNetworkSettings withSubnetMask(String subnetMask) {
        this.setSubnetMask(subnetMask);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDnsAddresses() != null) {
            sb.append("DnsAddresses: ").append(this.getDnsAddresses()).append(",");
        }
        if (this.getGateway() != null) {
            sb.append("Gateway: ").append(this.getGateway()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getIpScheme() != null) {
            sb.append("IpScheme: ").append(this.getIpScheme()).append(",");
        }
        if (this.getSubnetMask() != null) {
            sb.append("SubnetMask: ").append(this.getSubnetMask());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceNetworkSettings)) {
            return false;
        }
        InputDeviceNetworkSettings other = (InputDeviceNetworkSettings)obj;
        if (other.getDnsAddresses() == null ^ this.getDnsAddresses() == null) {
            return false;
        }
        if (other.getDnsAddresses() != null && !other.getDnsAddresses().equals(this.getDnsAddresses())) {
            return false;
        }
        if (other.getGateway() == null ^ this.getGateway() == null) {
            return false;
        }
        if (other.getGateway() != null && !other.getGateway().equals(this.getGateway())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getIpScheme() == null ^ this.getIpScheme() == null) {
            return false;
        }
        if (other.getIpScheme() != null && !other.getIpScheme().equals(this.getIpScheme())) {
            return false;
        }
        if (other.getSubnetMask() == null ^ this.getSubnetMask() == null) {
            return false;
        }
        return other.getSubnetMask() == null || other.getSubnetMask().equals(this.getSubnetMask());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDnsAddresses() == null ? 0 : this.getDnsAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getGateway() == null ? 0 : this.getGateway().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getIpScheme() == null ? 0 : this.getIpScheme().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetMask() == null ? 0 : this.getSubnetMask().hashCode());
        return hashCode;
    }

    public InputDeviceNetworkSettings clone() {
        try {
            return (InputDeviceNetworkSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDeviceNetworkSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

