/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.Mpeg2Settings;

@SdkInternalApi
public class Mpeg2SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").build();
    private static final MarshallingInfo<String> AFDSIGNALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afdSignaling").build();
    private static final MarshallingInfo<String> COLORMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorMetadata").build();
    private static final MarshallingInfo<String> COLORSPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorSpace").build();
    private static final MarshallingInfo<String> DISPLAYASPECTRATIO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayAspectRatio").build();
    private static final MarshallingInfo<StructuredPojo> FILTERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filterSettings").build();
    private static final MarshallingInfo<String> FIXEDAFD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fixedAfd").build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").build();
    private static final MarshallingInfo<Integer> GOPNUMBFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopNumBFrames").build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").build();
    private static final MarshallingInfo<String> SCANTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanType").build();
    private static final MarshallingInfo<String> SUBGOPLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subgopLength").build();
    private static final MarshallingInfo<String> TIMECODEINSERTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeInsertion").build();
    private static final Mpeg2SettingsMarshaller instance = new Mpeg2SettingsMarshaller();

    public static Mpeg2SettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Mpeg2Settings mpeg2Settings, ProtocolMarshaller protocolMarshaller) {
        if (mpeg2Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mpeg2Settings.getAdaptiveQuantization(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getAfdSignaling(), AFDSIGNALING_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getColorMetadata(), COLORMETADATA_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getColorSpace(), COLORSPACE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getDisplayAspectRatio(), DISPLAYASPECTRATIO_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getFilterSettings(), FILTERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getFixedAfd(), FIXEDAFD_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getFramerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getFramerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getGopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getGopNumBFrames(), GOPNUMBFRAMES_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getGopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getGopSizeUnits(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getScanType(), SCANTYPE_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getSubgopLength(), SUBGOPLENGTH_BINDING);
            protocolMarshaller.marshall((Object)mpeg2Settings.getTimecodeInsertion(), TIMECODEINSERTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

