/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputChannelLevel;
import com.amazonaws.services.medialive.model.transform.AudioChannelMappingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AudioChannelMapping
implements Serializable,
Cloneable,
StructuredPojo {
    private List<InputChannelLevel> inputChannelLevels;
    private Integer outputChannel;

    public List<InputChannelLevel> getInputChannelLevels() {
        return this.inputChannelLevels;
    }

    public void setInputChannelLevels(Collection<InputChannelLevel> inputChannelLevels) {
        if (inputChannelLevels == null) {
            this.inputChannelLevels = null;
            return;
        }
        this.inputChannelLevels = new ArrayList<InputChannelLevel>(inputChannelLevels);
    }

    public AudioChannelMapping withInputChannelLevels(InputChannelLevel ... inputChannelLevels) {
        if (this.inputChannelLevels == null) {
            this.setInputChannelLevels(new ArrayList<InputChannelLevel>(inputChannelLevels.length));
        }
        for (InputChannelLevel ele : inputChannelLevels) {
            this.inputChannelLevels.add(ele);
        }
        return this;
    }

    public AudioChannelMapping withInputChannelLevels(Collection<InputChannelLevel> inputChannelLevels) {
        this.setInputChannelLevels(inputChannelLevels);
        return this;
    }

    public void setOutputChannel(Integer outputChannel) {
        this.outputChannel = outputChannel;
    }

    public Integer getOutputChannel() {
        return this.outputChannel;
    }

    public AudioChannelMapping withOutputChannel(Integer outputChannel) {
        this.setOutputChannel(outputChannel);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInputChannelLevels() != null) {
            sb.append("InputChannelLevels: ").append(this.getInputChannelLevels()).append(",");
        }
        if (this.getOutputChannel() != null) {
            sb.append("OutputChannel: ").append(this.getOutputChannel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelMapping)) {
            return false;
        }
        AudioChannelMapping other = (AudioChannelMapping)obj;
        if (other.getInputChannelLevels() == null ^ this.getInputChannelLevels() == null) {
            return false;
        }
        if (other.getInputChannelLevels() != null && !other.getInputChannelLevels().equals(this.getInputChannelLevels())) {
            return false;
        }
        if (other.getOutputChannel() == null ^ this.getOutputChannel() == null) {
            return false;
        }
        return other.getOutputChannel() == null || other.getOutputChannel().equals(this.getOutputChannel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInputChannelLevels() == null ? 0 : this.getInputChannelLevels().hashCode());
        hashCode = 31 * hashCode + (this.getOutputChannel() == null ? 0 : this.getOutputChannel().hashCode());
        return hashCode;
    }

    public AudioChannelMapping clone() {
        try {
            return (AudioChannelMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioChannelMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

